/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.grammar.wiki.impl;

import org.exoplatform.services.grammar.wiki.impl.ParsingContext;

public class Token {
    public static final String DEFAULT_TOKEN = "default";
    public static final String BOLD_TOKEN = "**";
    public static final String ITALIC_TOKEN = "~~";
    public static final String STRIKE_TOKEN = "--";
    public static final String UNDERLINE_TOKEN = "__";
    public static final String HORIZONTAL_LINE_TOKEN = "---";
    public static final String SINGLE_NEW_LINE_TOKEN = "\n";
    public static final String MULTIPLE_NEW_LINE_TOKEN = "\n+";
    public static final String SMILEY_TOKEN = "smiley";
    public static final String BEAN_INTROSPECTION_TOKEN = "introspection";
    public static final String TITLE_1_TOKEN = "\n 1 ";
    public static final String TITLE_1_1_TOKEN = "\n 1.1";
    public static final String LINK_TOKEN = "[.+]";
    public static final String LIST_LEVEL_1_TOKEN = "\n *";
    public static final String LIST_LEVEL_2_TOKEN = "\n **";
    public static final String LIST_LEVEL_3_TOKEN = "\n ***";
    public static final String ENUMERATED_TOKEN = "\n 1.";
    public static final String ALPHABETICAL_ENUMERATED_TOKEN = "\n a.";
    public static final String ROMAN_ENUMERATED_TOKEN = "\n i.";
    public static final String CURLY_BRACES_TOKEN = "{.+}";
    public static final String SINGLE_TOKEN_GROUP = "single";
    public static final String INLINE_TOKEN_GROUP = "inline";
    public static final String BLOCK_TOKEN_GROUP = "block";
    int start;
    int end;
    String type;
    String group;
    Token parent;

    Token(int start, int end) {
        this.start = start;
        this.end = end;
    }

    Token(int start, int end, String type) {
        this.start = start;
        this.end = end;
        this.type = type;
    }

    Token(Token token) {
        this.start = token.start;
        this.end = token.end;
        this.type = token.type;
        this.group = token.group;
        this.parent = token.parent;
    }

    public void clone(Token token) {
        this.start = token.start;
        this.end = token.end;
        this.type = token.type;
        this.group = token.group;
        this.parent = token.parent;
    }

    public final String getTokenImage(ParsingContext context) {
        return context.getSubstring(this.start, this.end);
    }

    public String getTokenType() {
        return this.type;
    }

    public String getTokenGroup() {
        return this.group;
    }

    public boolean hasAncestor(String type) {
        Token p = this.parent;
        while (p != null) {
            if (p.type == type) {
                return true;
            }
            p = p.parent;
        }
        return false;
    }
}

