/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.grammar.wiki.impl;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.sf.cglib.util.StringSwitcher;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.services.grammar.wiki.impl.ParsingContext;
import org.exoplatform.services.grammar.wiki.impl.Token;
import org.exoplatform.services.grammar.wiki.impl.TokenHandler;
import org.exoplatform.services.log.LogUtil;

public class TokenHandlerManager {
    private TokenHandler[] handlers_;
    private TokenHandler defaultHandler_;
    private List monitors_;
    private StringSwitcher switcher_;

    public TokenHandlerManager(InitParams params) {
        Map map = this.initHandlers(params);
        this.defaultHandler_ = (TokenHandler)map.get("default");
        this.handlers_ = new TokenHandler[map.size()];
        String[] keys = new String[map.size()];
        int[] index = new int[map.size()];
        int counter = 0;
        for (Map.Entry entry : map.entrySet()) {
            this.handlers_[counter] = (TokenHandler)entry.getValue();
            keys[counter] = (String)entry.getKey();
            index[counter] = counter;
            ++counter;
        }
        this.switcher_ = StringSwitcher.create((String[])keys, (int[])index, (boolean)false);
        this.monitors_ = new ArrayList();
    }

    private Map initHandlers(InitParams params) {
        ExtMap map = new ExtMap();
        ArrayList handlers = params.getValuesParam("token.handlers").getValues();
        for (int i = 0; i < handlers.size(); ++i) {
            String handler = (String)handlers.get(i);
            try {
                Class<?> clazz = Class.forName(handler);
                TokenHandler thandler = (TokenHandler)clazz.newInstance();
                thandler.init(params);
                map.put(thandler);
                continue;
            }
            catch (Exception ex) {
                LogUtil.getLog(this.getClass()).error((Object)"create handler", (Throwable)ex);
            }
        }
        return map;
    }

    public void reinit(ParsingContext context) {
        for (int i = 0; i < this.monitors_.size(); ++i) {
            TokenHandler handler = (TokenHandler)this.monitors_.get(i);
            handler.reinit(context);
        }
        this.monitors_.clear();
    }

    public void addMonitor(TokenHandler handler) {
        if (this.monitors_.contains(handler)) {
            return;
        }
        this.monitors_.add(handler);
    }

    public void removeMonitor(TokenHandler handler) {
        this.monitors_.remove(handler);
    }

    public Token handleToken(Token parent, Token token, ParsingContext context) {
        int index = this.switcher_.intValue(token.getTokenType());
        if (index < 0) {
            return this.defaultHandler_.handleToken(parent, token, context);
        }
        return this.handlers_[index].handleToken(parent, token, context);
    }

    class ExtMap
    extends HashMap {
        ExtMap() {
        }

        public void put(TokenHandler handler) {
            String[] key = handler.getHandleableTokenType();
            for (int i = 0; i < key.length; ++i) {
                this.put(key[i], handler);
            }
        }
    }
}

