/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.grammar.wiki.impl;

import org.apache.commons.pool.BasePoolableObjectFactory;
import org.apache.commons.pool.ObjectPool;
import org.apache.commons.pool.PoolableObjectFactory;
import org.apache.commons.pool.impl.StackObjectPool;
import org.exoplatform.commons.utils.ExceptionUtil;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.services.grammar.wiki.WikiContext;
import org.exoplatform.services.grammar.wiki.WikiEngineService;
import org.exoplatform.services.grammar.wiki.impl.ParsingContext;

public class WikiEngineServiceImpl
implements WikiEngineService {
    private ObjectPool pool;

    public WikiEngineServiceImpl(InitParams params) throws Exception {
        this.pool = new StackObjectPool((PoolableObjectFactory)new ParsingContextFactory(params));
    }

    public String toXHTML(String text) {
        return this.toXHTML(text, null);
    }

    public String toXHTML(String wiki, WikiContext context) {
        ParsingContext parsingContext = null;
        String result = null;
        try {
            parsingContext = (ParsingContext)this.pool.borrowObject();
            parsingContext.setWikiContext(context);
            parsingContext.transform(wiki);
            result = parsingContext.getOutputBuffer().toString();
        }
        catch (Exception ex) {
            result = wiki + "<br/><br/>=========-CANNOT CONVERT WIKI TO HTML===========<br/>" + ExceptionUtil.getStackTrace((Throwable)ex, (int)15);
        }
        return result;
    }

    static class ParsingContextFactory
    extends BasePoolableObjectFactory {
        InitParams params_;

        ParsingContextFactory(InitParams params) {
            this.params_ = params;
        }

        public Object makeObject() {
            return new ParsingContext(this.params_);
        }

        public void passivateObject(Object obj) {
        }
    }
}

