/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.indexing;

import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.TermQuery;
import org.exoplatform.container.component.ComponentPlugin;
import org.exoplatform.services.indexing.IndexerPlugin;
import org.exoplatform.services.indexing.IndexingService;
import org.exoplatform.services.indexing.Searcher;

public abstract class BaseIndexerPlugin
implements ComponentPlugin,
IndexerPlugin {
    public static final String[] MANDATORY_FIELDS = new String[]{"document-identifier", "document-module", "document-title", "document-body"};
    private String[] indexField_;
    private Searcher searcher_;
    protected IndexingService iservice_;

    public void init(IndexingService iservice) {
        this.iservice_ = iservice;
    }

    public abstract String getPluginIdentifier();

    public final String[] getMandatoryIndexFields() {
        return MANDATORY_FIELDS;
    }

    public String[] getCustomizedIndexFields() {
        return this.indexField_;
    }

    public synchronized Searcher getSearcher() throws Exception {
        if (this.searcher_ == null) {
            IndexSearcher isearcher = new IndexSearcher(this.iservice_.getIndexDatabaseLocation());
            this.searcher_ = new Searcher(isearcher, this.iservice_.getAnalyzer());
            this.searcher_.setQueryModules((Query)new TermQuery(new Term("document-module", this.getPluginIdentifier())));
        }
        return this.searcher_;
    }

    public synchronized void resetSearcher() {
        this.searcher_ = null;
    }

    protected Document createBaseDocument(String identifier, String author, String title, String description, String textToIndex, String viewRole) {
        Document doc = new Document();
        if (description == null) {
            description = textToIndex.length() < 50 ? textToIndex : textToIndex.substring(0, 50);
        }
        if (viewRole == null) {
            viewRole = "owner";
        }
        doc.add(Field.Keyword((String)"document-identifier", (String)identifier));
        doc.add(Field.Keyword((String)"document-module", (String)this.getPluginIdentifier()));
        doc.add(Field.Keyword((String)"document-author", (String)author));
        doc.add(Field.Text((String)"document-title", (String)title));
        doc.add(Field.Text((String)"document-description", (String)description));
        doc.add(Field.UnStored((String)"document-body", (String)textToIndex));
        doc.add(Field.UnStored((String)"document-accessRole", (String)viewRole));
        return doc;
    }

    public void removeIndex() throws Exception {
        Term term = new Term("document-module", this.getPluginIdentifier());
        this.iservice_.queueDeleteDocuments(term);
    }

    public void reindex() throws Exception {
        this.removeIndex();
    }

    public String getContentDescription(String text, int size) {
        char[] chars = text.toCharArray();
        StringBuffer b = new StringBuffer();
        int counter = 0;
        for (int i = 0; i < chars.length && counter < size; ++i) {
            if (chars[i] == '<') {
                while (i < chars.length && chars[i] != '>') {
                    ++i;
                }
                b.append(" - ");
                continue;
            }
            b.append(chars[i]);
            ++counter;
        }
        return b.toString();
    }

    public void start() {
    }

    public void stop() {
    }
}

