/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.indexing;

import java.util.ArrayList;
import java.util.List;
import org.apache.lucene.document.Document;
import org.apache.lucene.search.Hits;
import org.exoplatform.commons.utils.PageList;
import org.exoplatform.services.indexing.Searcher;

public class HitPageList
extends PageList {
    private Hits hits_;
    private Searcher searcher_;
    private float[] scores_;

    public HitPageList(Searcher searcher, int pageSize) throws Exception {
        super(pageSize);
        this.scores_ = new float[pageSize];
        this.searcher_ = searcher;
        this.hits_ = searcher.getLastSearchResult();
        this.setAvailablePage(this.hits_.length());
    }

    public HitPageList(Searcher searcher) throws Exception {
        this(searcher, 15);
    }

    public void setPageSize(int pageSize) {
        this.scores_ = new float[pageSize];
        super.setPageSize(pageSize);
    }

    protected void populateCurrentPage(int page) throws Exception {
        int from = this.getFrom();
        int to = this.getTo();
        this.currentListPage_ = new ArrayList(to - from);
        for (int i = from; i < to; ++i) {
            this.currentListPage_.add(this.hits_.doc(i));
            this.scores_[i - from] = this.hits_.score(i);
        }
    }

    public List getAll() throws Exception {
        int available = this.getAvailable();
        ArrayList<Document> list = new ArrayList<Document>(available);
        for (int i = 0; i < available; ++i) {
            list.add(this.hits_.doc(i));
        }
        return list;
    }

    public Document getDocumentInPage(int idx) {
        return (Document)this.currentListPage_.get(idx);
    }

    public float getScoreOfDocumentInPage(int idx) {
        return this.scores_[idx];
    }

    public Document getDocument(int idx) throws Exception {
        return this.hits_.doc(idx);
    }

    public Searcher getSearcher() {
        return this.searcher_;
    }
}

