/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.indexing;

import java.util.Date;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.document.DateField;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.RangeQuery;
import org.exoplatform.services.indexing.SearchInput;

public class RangeFieldSearchInput
implements SearchInput {
    private String field_;
    private String lowerTerm_;
    private String upperTerm_;
    private boolean inclusive_ = true;

    public RangeFieldSearchInput(String field, Date lowerTerm, Date upperTerm) {
        this.field_ = field;
        if (lowerTerm != null) {
            this.lowerTerm_ = DateField.dateToString((Date)lowerTerm);
        }
        if (upperTerm != null) {
            this.upperTerm_ = DateField.dateToString((Date)upperTerm);
        }
    }

    public RangeFieldSearchInput(String field, String lowerTerm, String upperTerm) {
        this.field_ = field;
        this.lowerTerm_ = lowerTerm;
        this.upperTerm_ = upperTerm;
    }

    public String getField() {
        return this.field_;
    }

    public void setInclusive(boolean b) {
        this.inclusive_ = b;
    }

    public boolean hasTerm() {
        return this.upperTerm_ != null && this.upperTerm_.length() > 0 || this.lowerTerm_ != null && this.lowerTerm_.length() > 0;
    }

    public Query getQuery(Analyzer analyzer) throws Exception {
        Term lower = null;
        if (this.lowerTerm_ != null) {
            lower = new Term(this.field_, this.lowerTerm_);
        }
        Term upper = null;
        if (this.upperTerm_ != null) {
            upper = new Term(this.field_, this.upperTerm_);
        }
        return new RangeQuery(lower, upper, this.inclusive_);
    }
}

