/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.indexing;

import java.util.List;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.index.Term;
import org.apache.lucene.queryParser.ParseException;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.Hits;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.TermQuery;
import org.exoplatform.commons.exception.ExoMessageException;
import org.exoplatform.services.indexing.HitPageList;
import org.exoplatform.services.indexing.SearchInput;

public class Searcher {
    private org.apache.lucene.search.Searcher searcher_;
    private Query modules_;
    private Analyzer analyzer_;
    private Hits lastSearchResult_;

    public Searcher(IndexSearcher searcher, Analyzer analyzer) throws Exception {
        this.searcher_ = searcher;
        this.analyzer_ = analyzer;
    }

    public void setQueryModules(Query query) {
        this.modules_ = query;
    }

    public Hits getLastSearchResult() {
        return this.lastSearchResult_;
    }

    public HitPageList search(SearchInput input) throws Exception {
        try {
            BooleanQuery query = new BooleanQuery();
            if (this.modules_ != null) {
                query.add(this.modules_, true, false);
            }
            Query subQuery = input.getQuery(this.analyzer_);
            query.add(subQuery, true, false);
            this.lastSearchResult_ = this.searcher_.search((Query)query);
            return new HitPageList(this);
        }
        catch (ParseException ex) {
            Object[] args = new Object[]{ex.getMessage()};
            throw new ExoMessageException("Searcher.msg.search-expression-error", args);
        }
    }

    public HitPageList search(List inputs) throws Exception {
        try {
            BooleanQuery query = new BooleanQuery();
            if (this.modules_ != null) {
                query.add(this.modules_, true, false);
            }
            for (int i = 0; i < inputs.size(); ++i) {
                SearchInput input = (SearchInput)inputs.get(i);
                if (!input.hasTerm()) continue;
                Query subQuery = input.getQuery(this.analyzer_);
                query.add(subQuery, true, false);
            }
            this.lastSearchResult_ = this.searcher_.search((Query)query);
            return new HitPageList(this);
        }
        catch (ParseException ex) {
            Object[] args = new Object[]{ex.getMessage()};
            throw new ExoMessageException("Searcher.msg.search-expression-error", args);
        }
    }

    public HitPageList search(SearchInput input, List modules) throws Exception {
        try {
            BooleanQuery query = new BooleanQuery();
            if (modules != null && modules.size() > 0) {
                Query modulesQuery = this.createModuleQuery(modules);
                query.add(modulesQuery, true, false);
            }
            Query subQuery = input.getQuery(this.analyzer_);
            query.add(subQuery, true, false);
            this.lastSearchResult_ = this.searcher_.search((Query)query);
            return new HitPageList(this);
        }
        catch (ParseException ex) {
            Object[] args = new Object[]{ex.getMessage()};
            throw new ExoMessageException("Searcher.msg.search-expression-error", args);
        }
    }

    public HitPageList search(List inputs, List modules) throws Exception {
        try {
            BooleanQuery query = new BooleanQuery();
            if (modules != null && modules.size() > 0) {
                Query modulesQuery = this.createModuleQuery(modules);
                query.add(modulesQuery, true, false);
            }
            for (int i = 0; i < inputs.size(); ++i) {
                SearchInput input = (SearchInput)inputs.get(i);
                if (!input.hasTerm()) continue;
                Query subQuery = input.getQuery(this.analyzer_);
                query.add(subQuery, true, false);
            }
            this.lastSearchResult_ = this.searcher_.search((Query)query);
            return new HitPageList(this);
        }
        catch (ParseException ex) {
            Object[] args = new Object[]{ex.getMessage()};
            throw new ExoMessageException("Searcher.msg.search-expression-error", args);
        }
    }

    private Query createModuleQuery(List modules) {
        BooleanQuery modulesQuery = new BooleanQuery();
        for (int i = 0; i < modules.size(); ++i) {
            String module = (String)modules.get(i);
            TermQuery moduleQuery = new TermQuery(new Term("document-module", module));
            modulesQuery.add((Query)moduleQuery, false, false);
        }
        return modulesQuery;
    }

    protected void finalize() {
        try {
            this.searcher_.close();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }
}

