/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.indexing.impl;

import java.io.File;
import java.io.FileFilter;
import java.util.ArrayList;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;
import org.apache.lucene.index.Term;
import org.exoplatform.commons.utils.IOUtil;
import org.exoplatform.commons.utils.io.FileFilterByExtension;
import org.exoplatform.services.indexing.BaseIndexerPlugin;
import org.exoplatform.services.indexing.FileIndexerPlugin;

public class FileIndexerPluginImpl
extends BaseIndexerPlugin
implements FileIndexerPlugin {
    public Document createDocument(File file, String baseDir, String accessRole) throws Exception {
        String identifier = file.getAbsolutePath();
        String title = file.getName();
        String textToIndex = IOUtil.getFileContenntAsString((File)file);
        String desc = this.getContentDescription(textToIndex, 200);
        Document doc = this.createBaseDocument(identifier, "N/A", title, desc, textToIndex, accessRole);
        doc.add(Field.Keyword((String)"basedir", (String)baseDir));
        return doc;
    }

    public String getPluginIdentifier() {
        return "FileIndexerPlugin";
    }

    public Object getObject(String user, String objectId) throws Exception {
        return null;
    }

    public String getObjectAsText(String user, String objectId) throws Exception {
        String content = IOUtil.getFileContenntAsString((String)objectId);
        return content;
    }

    public String getObjectAsXHTML(String user, String objectId) throws Exception {
        String content = IOUtil.getFileContenntAsString((String)objectId);
        return content;
    }

    public String getObjectAsXML(String user, String objectId) throws Exception {
        String content = IOUtil.getFileContenntAsString((String)objectId);
        return content;
    }

    public void reindexDirectory(String directory, String accessRole, String[] acceptExt, boolean recursive) throws Exception {
        Term term = new Term("basedir", directory);
        this.iservice_.queueDeleteDocuments(term);
        this.indexDirectory(directory, accessRole, acceptExt, recursive);
    }

    public void indexDirectory(String directory, String accessRole, String[] acceptExt, boolean recursive) throws Exception {
        FileFilterByExtension filter = new FileFilterByExtension(acceptExt, recursive);
        File dir = new File(directory);
        if (!dir.exists() || dir.isFile()) {
            throw new Exception(directory + " is not a valid directory.");
        }
        this.traverse(dir, (FileFilter)filter, directory, accessRole);
    }

    private void traverse(File file, FileFilter filter, String baseDir, String accessRole) throws Exception {
        File[] files = file.listFiles(filter);
        ArrayList<Document> documents = new ArrayList<Document>();
        for (int i = 0; i < files.length; ++i) {
            if (files[i].isFile()) {
                documents.add(this.createDocument(files[i], baseDir, accessRole));
                continue;
            }
            this.traverse(files[i], filter, baseDir, accessRole);
        }
        if (documents.size() > 0) {
            this.iservice_.queueIndexDocuments(documents);
        }
    }

    public String getName() {
        return null;
    }

    public void setName(String s) {
    }

    public String getDescription() {
        return null;
    }

    public void setDescription(String s) {
    }
}

