/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.indexing.impl;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.document.Document;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.IndexSearcher;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.container.component.ComponentPlugin;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.container.xml.ValueParam;
import org.exoplatform.services.indexing.IndexerPlugin;
import org.exoplatform.services.indexing.IndexingService;
import org.exoplatform.services.indexing.Searcher;
import org.exoplatform.services.log.LogService;
import org.picocontainer.Startable;

public class IndexingServiceImpl
implements IndexingService,
Startable {
    private static final String UPDATE_ACTION = "update";
    private static final String ADD_ACTION = "add";
    private static final String DELETE_ACTION = "delete";
    private Analyzer analyzer_;
    private Map plugins_;
    private List queues_;
    private String indexDBLocation_;
    private Searcher searcher_;
    private Log log_;
    private int counter_;
    private boolean isRunning = false;

    public IndexingServiceImpl(InitParams params, LogService lservice, Analyzer analyzer) throws Exception {
        File segments;
        File dir;
        this.log_ = lservice.getLog(this.getClass());
        this.analyzer_ = analyzer;
        this.plugins_ = new HashMap();
        this.queues_ = new ArrayList(200);
        ValueParam param = params.getValueParam("index.database.dir");
        this.indexDBLocation_ = param.getValue();
        if (this.indexDBLocation_.equals("default")) {
            this.indexDBLocation_ = System.getProperty("java.io.tmpdir") + "/lucenedb";
        }
        if ((dir = new File(this.indexDBLocation_)).isFile()) {
            throw new Exception("Expect a directory, but " + this.indexDBLocation_ + " is a file");
        }
        if (!dir.exists()) {
            dir.mkdir();
        }
        if (!(segments = new File(this.indexDBLocation_ + "/segments")).exists()) {
            IndexWriter writer = new IndexWriter(this.indexDBLocation_, this.analyzer_, true);
            writer.optimize();
            writer.close();
        }
    }

    public Analyzer getAnalyzer() {
        return this.analyzer_;
    }

    public String getIndexDatabaseLocation() {
        return this.indexDBLocation_;
    }

    public Collection getIndexerPlugins() throws Exception {
        return this.plugins_.values();
    }

    public void addIndexerPlugin(ComponentPlugin plugin) {
        this.addIndexerPlugin((IndexerPlugin)plugin);
    }

    public void addIndexerPlugin(IndexerPlugin plugin) {
        plugin.init((IndexingService)this);
        this.plugins_.put(plugin.getPluginIdentifier(), plugin);
    }

    public IndexerPlugin getIndexerPlugin(String identifier) throws Exception {
        IndexerPlugin plugin = (IndexerPlugin)this.plugins_.get(identifier);
        if (plugin == null) {
            throw new Exception("Cannot find the plugin: " + identifier);
        }
        return plugin;
    }

    public synchronized Searcher getSearcher() throws Exception {
        if (this.searcher_ == null) {
            IndexSearcher isearcher = new IndexSearcher(this.getIndexDatabaseLocation());
            this.searcher_ = new Searcher(isearcher, this.analyzer_);
        }
        return this.searcher_;
    }

    public synchronized void queueUpdateDocument(Document document) throws Exception {
        Term deleteQuery = new Term("document-identifier", document.getField("document-identifier").stringValue());
        this.queues_.add(new Command(UPDATE_ACTION, deleteQuery, document));
        this.activateIndexerThread();
    }

    public synchronized void queueUpdateDocuments(List documents) throws Exception {
        for (int i = 0; i < documents.size(); ++i) {
            Document document = (Document)documents.get(i);
            Term deleteQuery = new Term("document-identifier", document.getField("document-identifier").stringValue());
            this.queues_.add(new Command(UPDATE_ACTION, deleteQuery, document));
        }
        this.activateIndexerThread();
    }

    public synchronized void queueIndexDocument(Document document) throws Exception {
        this.queues_.add(new Command(ADD_ACTION, null, document));
        this.activateIndexerThread();
    }

    public synchronized void queueIndexDocuments(List documents) throws Exception {
        for (int i = 0; i < documents.size(); ++i) {
            Document document = (Document)documents.get(i);
            this.queues_.add(new Command(ADD_ACTION, null, document));
        }
        this.activateIndexerThread();
    }

    public synchronized void queueDeleteDocuments(Term queryTerm) throws Exception {
        this.queues_.add(new Command(DELETE_ACTION, queryTerm, null));
        this.activateIndexerThread();
    }

    private synchronized List dequeue() throws Exception {
        List tmp = this.queues_;
        this.queues_ = new ArrayList(200);
        return tmp;
    }

    private void activateIndexerThread() {
    }

    private void runBatchCommand(List commands) throws Exception {
        if (commands.size() == 0) {
            return;
        }
        IndexReader reader = null;
        for (int i = 0; i < commands.size(); ++i) {
            Command entry = (Command)commands.get(i);
            if (entry.command_ != UPDATE_ACTION && entry.command_ != DELETE_ACTION) continue;
            if (reader == null) {
                reader = IndexReader.open((String)this.indexDBLocation_);
            }
            int deleted = reader.delete(entry.deleteQuery_);
            this.log_.debug((Object)("Deleted " + deleted + " docs"));
        }
        if (reader != null) {
            reader.close();
        }
        IndexWriter writer = new IndexWriter(this.indexDBLocation_, this.analyzer_, false);
        for (int i = 0; i < commands.size(); ++i) {
            Command entry = (Command)commands.get(i);
            if (entry.command_ == UPDATE_ACTION || entry.command_ == ADD_ACTION) {
                writer.addDocument(entry.document_);
            }
            ++this.counter_;
        }
        writer.optimize();
        writer.close();
    }

    public void optimizeDatabase() throws Exception {
        IndexWriter writer = new IndexWriter(this.indexDBLocation_, this.analyzer_, false);
        writer.optimize();
        writer.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void reindex(String pluginId) throws Exception {
        if (this.isRunning) {
            return;
        }
        this.isRunning = true;
        try {
            IndexerPlugin plugin = this.getIndexerPlugin(pluginId);
            plugin.reindex();
        }
        finally {
            this.isRunning = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void execute() {
        if (this.isRunning) {
            return;
        }
        this.isRunning = true;
        try {
            List queues = this.dequeue();
            while (queues.size() > 0) {
                this.runBatchCommand(queues);
                queues = this.dequeue();
            }
            for (IndexerPlugin plugin : this.plugins_.values()) {
                plugin.resetSearcher();
            }
            this.searcher_ = null;
        }
        catch (Exception ex) {
            this.log_.error((Object)"Error while indexing the new document entries: ", (Throwable)ex);
        }
        finally {
            this.isRunning = false;
        }
    }

    public String getName() {
        return "IndexingServiceImpl";
    }

    public String getDescription() {
        return "index the data, there are " + this.queues_.size() + " in the queue";
    }

    public PortalContainer getPortalContainer() {
        return null;
    }

    public void start() {
    }

    public void stop() {
    }

    private class Command {
        String command_;
        Term deleteQuery_;
        Document document_;

        public Command(String action, Term deleteQuery, Document doc) {
            this.command_ = action;
            this.deleteQuery_ = deleteQuery;
            this.document_ = doc;
        }
    }
}

