/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.ldap;

import java.util.List;
import javax.naming.NamingEnumeration;
import javax.naming.directory.SearchControls;
import javax.naming.directory.SearchResult;
import javax.naming.ldap.LdapContext;
import org.exoplatform.container.component.BaseComponentPlugin;
import org.exoplatform.container.xml.InitParams;

public class DeleteObjectCommand
extends BaseComponentPlugin {
    public List<String> objectsToDelete_;

    public DeleteObjectCommand(InitParams params) {
        this.objectsToDelete_ = params.getValuesParam("objects.to.delete").getValues();
    }

    public void deleteObjects(LdapContext context) {
        for (String dn : this.objectsToDelete_) {
            this.unbind(context, dn);
        }
    }

    private void unbind(LdapContext context, String dn) {
        try {
            SearchControls constraints = new SearchControls();
            constraints.setSearchScope(1);
            NamingEnumeration<SearchResult> results = context.search(dn, "(objectclass=*)", constraints);
            while (results.hasMore()) {
                SearchResult sr = results.next();
                this.unbind(context, sr.getNameInNamespace());
            }
            context.unbind(dn);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

