/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.organization;

import java.util.List;
import org.exoplatform.commons.utils.PageList;
import org.exoplatform.container.component.BaseComponentPlugin;
import org.exoplatform.container.component.ComponentPlugin;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.services.organization.Group;
import org.exoplatform.services.organization.MembershipHandler;
import org.exoplatform.services.organization.MembershipType;
import org.exoplatform.services.organization.OrganizationConfig;
import org.exoplatform.services.organization.OrganizationService;
import org.exoplatform.services.organization.OrganizationServiceInitializer;
import org.exoplatform.services.organization.User;

public class OrganizationDatabaseInitializer
extends BaseComponentPlugin
implements OrganizationServiceInitializer,
ComponentPlugin {
    private OrganizationConfig config_;
    private static int CHECK_EMPTY = 0;
    private static int CHECK_ENTRY = 1;
    private int checkDatabaseAlgorithm_ = CHECK_EMPTY;
    private boolean printInfo_ = true;

    public OrganizationDatabaseInitializer(InitParams params) throws Exception {
        String checkConfig = params.getValueParam("checkDatabaseAlgorithm").getValue();
        this.checkDatabaseAlgorithm_ = checkConfig.trim().equalsIgnoreCase("entry") ? CHECK_ENTRY : CHECK_EMPTY;
        String printInfoConfig = params.getValueParam("printInformation").getValue();
        this.printInfo_ = printInfoConfig.trim().equalsIgnoreCase("true");
        this.config_ = (OrganizationConfig)params.getObjectParamValues(OrganizationConfig.class).get(0);
    }

    public void init(OrganizationService service) throws Exception {
        if (this.checkDatabaseAlgorithm_ == CHECK_EMPTY && this.checkExistDatabase(service)) {
            return;
        }
        String alg = "check empty database";
        if (this.checkDatabaseAlgorithm_ == CHECK_ENTRY) {
            alg = "check entry database";
        }
        this.printInfo("=======> Initialize the  organization service data  using algorithm " + alg);
        this.createGroups(service);
        this.createMembershipTypes(service);
        this.createUsers(service);
        this.printInfo("<=======");
    }

    private boolean checkExistDatabase(OrganizationService service) throws Exception {
        PageList users = service.getUserHandler().getUserPageList(10);
        return users != null && users.getAvailable() > 0;
    }

    private void createGroups(OrganizationService orgService) throws Exception {
        this.printInfo("  Init  Group Data");
        List groups = this.config_.getGroup();
        for (int i = 0; i < groups.size(); ++i) {
            OrganizationConfig.Group data = (OrganizationConfig.Group)groups.get(i);
            String groupId = null;
            String parentId = data.getParentId();
            groupId = parentId == null || parentId.length() == 0 ? "/" + data.getName() : data.getParentId() + "/" + data.getName();
            if (orgService.getGroupHandler().findGroupById(groupId) == null) {
                Group group = orgService.getGroupHandler().createGroupInstance();
                group.setGroupName(data.getName());
                group.setDescription(data.getDescription());
                if (parentId == null || parentId.length() == 0) {
                    orgService.getGroupHandler().addChild(null, group, true);
                } else {
                    Group parentGroup = orgService.getGroupHandler().findGroupById(parentId);
                    orgService.getGroupHandler().addChild(parentGroup, group, true);
                }
                this.printInfo("    Create Group " + groupId);
                continue;
            }
            this.printInfo("    Group " + groupId + " is existed, ignore the entry");
        }
    }

    private void createMembershipTypes(OrganizationService service) throws Exception {
        this.printInfo("  Init  Membership Type  Data");
        List types = this.config_.getMembershipType();
        for (int i = 0; i < types.size(); ++i) {
            OrganizationConfig.MembershipType data = (OrganizationConfig.MembershipType)types.get(i);
            if (service.getMembershipTypeHandler().findMembershipType(data.getType()) == null) {
                MembershipType type = service.getMembershipTypeHandler().createMembershipTypeInstance();
                type.setName(data.getType());
                type.setDescription(data.getDescription());
                service.getMembershipTypeHandler().createMembershipType(type, true);
                this.printInfo("    Created Membership Type " + data.getType());
                continue;
            }
            this.printInfo("    Membership Type " + data.getType() + " is existed, ignore the entry");
        }
    }

    private void createUsers(OrganizationService service) throws Exception {
        this.printInfo("  Init  User  Data");
        List users = this.config_.getUser();
        MembershipHandler mhandler = service.getMembershipHandler();
        for (int i = 0; i < users.size(); ++i) {
            OrganizationConfig.User data = (OrganizationConfig.User)users.get(i);
            User user = service.getUserHandler().createUserInstance();
            user.setUserName(data.getUserName());
            user.setPassword(data.getPassword());
            user.setFirstName(data.getFirstName());
            user.setLastName(data.getLastName());
            user.setEmail(data.getEmail());
            if (service.getUserHandler().findUserByName(data.getUserName()) == null) {
                service.getUserHandler().createUser(user, true);
                this.printInfo("    Created user " + data.getUserName());
            } else {
                this.printInfo("    User " + data.getUserName() + " is existed, ignore the entry");
            }
            String groups = data.getGroups();
            String[] entry = groups.split(",");
            for (int j = 0; j < entry.length; ++j) {
                String[] temp = entry[j].trim().split(":");
                String membership = temp[0];
                String groupId = temp[1];
                if (mhandler.findMembershipByUserGroupAndType(data.getUserName(), groupId, membership) == null) {
                    Group group = service.getGroupHandler().findGroupById(groupId);
                    MembershipType mt = service.getMembershipTypeHandler().createMembershipTypeInstance();
                    mt.setName(membership);
                    mhandler.linkMembership(user, group, mt, true);
                    this.printInfo("    Created membership " + data.getUserName() + ", " + groupId + ", " + membership);
                    continue;
                }
                this.printInfo("    Ignore membership " + data.getUserName() + ", " + groupId + ", " + membership);
            }
        }
    }

    private void printInfo(String message) {
        if (this.printInfo_) {
            System.out.println(message);
        }
    }
}

