/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.organization.hibernate;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.exoplatform.services.cache.CacheService;
import org.exoplatform.services.cache.ExoCache;
import org.exoplatform.services.database.HibernateService;
import org.exoplatform.services.organization.UserProfile;
import org.exoplatform.services.organization.UserProfileEventListener;
import org.exoplatform.services.organization.UserProfileHandler;
import org.exoplatform.services.organization.impl.UserProfileData;
import org.exoplatform.services.organization.impl.UserProfileImpl;
import org.hibernate.Session;

public class UserProfileDAOImpl
implements UserProfileHandler {
    private static UserProfile NOT_FOUND = new UserProfileImpl();
    private static final String queryFindUserProfileByName = "from u in class org.exoplatform.services.organization.impl.UserProfileData where u.userName = ?";
    private HibernateService service_;
    private ExoCache cache_;
    private List<UserProfileEventListener> listeners_;

    public UserProfileDAOImpl(HibernateService service, CacheService cservice) throws Exception {
        this.service_ = service;
        this.cache_ = cservice.getCacheInstance(this.getClass().getName());
        this.listeners_ = new ArrayList<UserProfileEventListener>(3);
    }

    public void addUserProfileEventListener(UserProfileEventListener listener) {
        this.listeners_.add(listener);
    }

    public final UserProfile createUserProfileInstance() {
        return new UserProfileImpl();
    }

    void createUserProfileEntry(UserProfile up, Session session) throws Exception {
        UserProfileData upd = new UserProfileData();
        upd.setUserProfile(up);
        session.save((Object)upd);
        session.flush();
        this.cache_.remove((Serializable)((Object)up.getUserName()));
    }

    public void saveUserProfile(UserProfile profile, boolean broadcast) throws Exception {
        Session session = this.service_.openSession();
        UserProfileData upd = (UserProfileData)this.service_.findOne(session, queryFindUserProfileByName, profile.getUserName());
        if (upd == null) {
            upd = new UserProfileData();
            upd.setUserProfile(profile);
            session.save(profile.getUserName(), (Object)upd);
            session.flush();
        } else {
            upd.setUserProfile(profile);
            session.update((Object)upd);
            session.flush();
        }
        this.cache_.put((Serializable)((Object)profile.getUserName()), (Object)profile);
    }

    public UserProfile removeUserProfile(String userName, boolean broadcast) throws Exception {
        Session session = this.service_.openSession();
        try {
            UserProfileData upd = (UserProfileData)this.service_.findExactOne(session, queryFindUserProfileByName, userName);
            session.delete((Object)upd);
            session.flush();
            this.cache_.remove((Serializable)((Object)userName));
            return upd.getUserProfile();
        }
        catch (Exception exp) {
            return null;
        }
    }

    public UserProfile findUserProfileByName(String userName) throws Exception {
        UserProfile up = (UserProfile)this.cache_.get((Serializable)((Object)userName));
        if (up != null) {
            if (NOT_FOUND == up) {
                return null;
            }
            return up;
        }
        Session session = this.service_.openSession();
        up = this.findUserProfileByName(userName, session);
        if (up != null) {
            this.cache_.put((Serializable)((Object)userName), (Object)up);
        } else {
            this.cache_.put((Serializable)((Object)userName), (Object)NOT_FOUND);
        }
        return up;
    }

    public UserProfile findUserProfileByName(String userName, Session session) throws Exception {
        UserProfileData upd = (UserProfileData)this.service_.findOne(session, queryFindUserProfileByName, userName);
        if (upd != null) {
            return upd.getUserProfile();
        }
        return null;
    }

    static void removeUserProfileEntry(String userName, Session session) throws Exception {
        Object user = session.createQuery(queryFindUserProfileByName).setString(0, userName).uniqueResult();
        if (user != null) {
            session.delete(user);
        }
    }

    public Collection findUserProfiles() throws Exception {
        return null;
    }
}

