/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.organization.impl;

import java.io.PrintWriter;
import java.io.Writer;
import java.util.Collection;
import java.util.Iterator;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.apache.velocity.Template;
import org.apache.velocity.VelocityContext;
import org.apache.velocity.context.Context;
import org.exoplatform.services.backup.DataTransformer;
import org.exoplatform.services.backup.ImportExportPlugin;
import org.exoplatform.services.organization.Group;
import org.exoplatform.services.organization.MembershipType;
import org.exoplatform.services.organization.OrganizationService;
import org.exoplatform.services.organization.impl.ImportExportPluginImpl;

public class DataTransformerImpl
extends DataTransformer {
    private OrganizationService orgService_;

    public void init(ImportExportPlugin plugin) throws Exception {
        ImportExportPluginImpl impl = (ImportExportPluginImpl)plugin;
        this.orgService_ = impl.orgService_;
    }

    public void transformUserData(String username, ZipOutputStream os) throws Exception {
        Template template = this.getUserTemplate();
        VelocityContext context = new VelocityContext();
        Object object = this.orgService_.getUserHandler().findUserByName(username);
        context.put("user", object);
        object = this.orgService_.getUserProfileHandler().findUserProfileByName(username);
        context.put("profile", object);
        object = this.orgService_.getMembershipHandler().findMembershipsByUser(username);
        context.put("memberships", object);
        os.putNextEntry(new ZipEntry("user" + this.getUserEntryExtension()));
        PrintWriter w = new PrintWriter(os);
        template.merge((Context)context, (Writer)w);
        w.flush();
        os.closeEntry();
    }

    public void transformServiceData(ZipOutputStream os) throws Exception {
        Template template = this.getServiceTemplate();
        PrintWriter w = new PrintWriter(os);
        Collection groups = this.orgService_.getGroupHandler().getAllGroups();
        Iterator i = groups.iterator();
        VelocityContext context = new VelocityContext();
        while (i.hasNext()) {
            Group data = (Group)i.next();
            ZipEntry entry = new ZipEntry("group/" + data.getId() + this.getServiceEntryExtension());
            os.putNextEntry(entry);
            context.put("group", (Object)data);
            template.merge((Context)context, (Writer)w);
            w.flush();
            os.closeEntry();
        }
        Collection membershipTypes = this.orgService_.getMembershipTypeHandler().findMembershipTypes();
        i = membershipTypes.iterator();
        context = new VelocityContext();
        while (i.hasNext()) {
            MembershipType data = (MembershipType)i.next();
            ZipEntry entry = new ZipEntry("membership-type/" + data.getName() + this.getServiceEntryExtension());
            os.putNextEntry(entry);
            context.put("type", (Object)data);
            template.merge((Context)context, (Writer)w);
            w.flush();
            os.closeEntry();
        }
    }
}

