/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.organization.impl;

import java.io.InputStream;
import java.util.Collection;
import java.util.Enumeration;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipOutputStream;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.services.backup.ImportExportPlugin;
import org.exoplatform.services.backup.Metadata;
import org.exoplatform.services.backup.XMLObjectConverter;
import org.exoplatform.services.organization.Group;
import org.exoplatform.services.organization.Membership;
import org.exoplatform.services.organization.MembershipType;
import org.exoplatform.services.organization.OrganizationService;
import org.exoplatform.services.organization.User;
import org.exoplatform.services.organization.UserProfile;
import org.exoplatform.services.organization.impl.GroupImpl;
import org.exoplatform.services.organization.impl.MembershipTypeImpl;
import org.exoplatform.xml.object.XMLCollection;
import org.exoplatform.xml.object.XMLObject;

public class ImportExportPluginImpl
extends ImportExportPlugin {
    static String PLUGIN_NAME = "organization";
    static String USER_META_DATA_ENTRY = "organization/metadata.xml";
    static String USER_DATA_ENTRY = "organization/User.xml";
    static String USER_PROFILE_DATA_ENTRY = "organization/UserProfile.xml";
    static String USER_MEMBERSHIPS_DATA_ENTRY = "organization/Memberships.xml";
    static String SERVICE_META_DATA_ENTRY = "metadata.xml";
    OrganizationService orgService_;

    public ImportExportPluginImpl(OrganizationService service, InitParams params) throws Exception {
        this.orgService_ = service;
        this.init(params);
    }

    public void exportUserData(String userName, ZipOutputStream os) throws Exception {
        Metadata mdata = new Metadata(this.getCurrentDataVersion(), this.getDescription(), "single-user");
        this.createEntry(USER_META_DATA_ENTRY, os, mdata);
        Object object = this.orgService_.getUserHandler().findUserByName(userName);
        this.createEntry(USER_DATA_ENTRY, os, object);
        object = this.orgService_.getUserProfileHandler().findUserProfileByName(userName);
        if (object == null) {
            object = this.orgService_.getUserProfileHandler().createUserProfileInstance();
            ((UserProfile)object).setUserName(userName);
        }
        this.createEntry(USER_PROFILE_DATA_ENTRY, os, object);
        object = this.orgService_.getMembershipHandler().findMembershipsByUser(userName);
        this.createEntry(USER_MEMBERSHIPS_DATA_ENTRY, os, object);
    }

    public void importUserData(String username, ZipFile zipFile) throws Exception {
        Metadata mdata = this.getMetadata(USER_META_DATA_ENTRY, zipFile);
        String dataVersion = mdata.getDataVersion();
        XMLObjectConverter converter = this.getXMLObjectConverter(dataVersion);
        InputStream input = this.getEntry(USER_DATA_ENTRY, zipFile);
        XMLObject xmlobject = XMLObject.getXMLObject((InputStream)input);
        input.close();
        if (converter != null) {
            converter.traverse(xmlobject);
        }
        User user = (User)xmlobject.toObject();
        this.orgService_.getUserHandler().createUser(user, false);
        input = this.getEntry(USER_PROFILE_DATA_ENTRY, zipFile);
        xmlobject = XMLObject.getXMLObject((InputStream)input);
        input.close();
        if (converter != null) {
            converter.traverse(xmlobject);
        }
        UserProfile up = (UserProfile)xmlobject.toObject();
        this.orgService_.getUserProfileHandler().saveUserProfile(up, false);
        input = this.getEntry(USER_MEMBERSHIPS_DATA_ENTRY, zipFile);
        XMLCollection xmlCol = XMLCollection.getXMLCollection((InputStream)input);
        input.close();
        if (converter != null) {
            converter.traverse(xmlCol);
        }
        Collection memberships = xmlCol.getCollection();
        for (Membership m : memberships) {
            Group g = this.orgService_.getGroupHandler().findGroupById(m.getGroupId());
            MembershipType mt = this.orgService_.getMembershipTypeHandler().findMembershipType(m.getMembershipType());
            if (g == null || mt == null) continue;
            this.orgService_.getMembershipHandler().linkMembership(user, g, mt, false);
        }
    }

    public void exportServiceData(ZipOutputStream os) throws Exception {
        Metadata mdata = new Metadata(this.getCurrentDataVersion(), this.getDescription(), "single-service");
        this.createEntry(SERVICE_META_DATA_ENTRY, os, mdata);
        Collection groups = this.orgService_.getGroupHandler().getAllGroups();
        for (Group data : groups) {
            ZipEntry entry = new ZipEntry("group" + data.getId() + ".xml");
            os.putNextEntry(entry);
            XMLObject xmlobject = new XMLObject((Object)data);
            os.write(xmlobject.toByteArray("UTF-8"));
            os.closeEntry();
        }
        Collection membershipTypes = this.orgService_.getMembershipTypeHandler().findMembershipTypes();
        for (MembershipType data : membershipTypes) {
            ZipEntry entry = new ZipEntry("membership-type/" + data.getName() + ".xml");
            os.putNextEntry(entry);
            XMLObject xmlobject = new XMLObject((Object)data);
            os.write(xmlobject.toByteArray("UTF-8"));
            os.closeEntry();
        }
    }

    public void importServiceData(ZipFile in) throws Exception {
        Metadata mdata = this.getMetadata(SERVICE_META_DATA_ENTRY, in);
        String dataVersion = mdata.getDataVersion();
        XMLObjectConverter converter = this.getXMLObjectConverter(dataVersion);
        Enumeration<? extends ZipEntry> e = in.entries();
        XMLObject xmlobject = null;
        while (e.hasMoreElements()) {
            Object data;
            String entryName;
            ZipEntry entry = e.nextElement();
            InputStream is = in.getInputStream(entry);
            xmlobject = XMLObject.getXMLObject((InputStream)is);
            if (converter != null) {
                converter.traverse(xmlobject);
            }
            if ((entryName = entry.getName()).startsWith("group/")) {
                data = (GroupImpl)xmlobject.toObject();
                Group g = this.orgService_.getGroupHandler().findGroupById(((GroupImpl)data).getId());
                if (g != null) {
                    this.orgService_.getGroupHandler().removeGroup(g, false);
                }
                this.orgService_.getGroupHandler().createGroup((Group)data, false);
            } else if (entryName.startsWith("membership-type/")) {
                data = (MembershipTypeImpl)xmlobject.toObject();
                this.orgService_.getMembershipTypeHandler().removeMembershipType(((MembershipTypeImpl)data).getName(), false);
                this.orgService_.getMembershipTypeHandler().createMembershipType((MembershipType)data, false);
            }
            is.close();
        }
    }
}

