/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.organization.ldap;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.naming.NamingEnumeration;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import javax.naming.directory.SearchControls;
import javax.naming.directory.SearchResult;
import javax.naming.ldap.LdapContext;
import org.exoplatform.services.ldap.LDAPService;
import org.exoplatform.services.organization.Group;
import org.exoplatform.services.organization.ldap.ADSearchBySID;
import org.exoplatform.services.organization.ldap.GroupDAOImpl;
import org.exoplatform.services.organization.ldap.LDAPAttributeMapping;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ADGroupDAOImpl
extends GroupDAOImpl {
    private ADSearchBySID adSearch;

    public ADGroupDAOImpl(LDAPAttributeMapping ldapAttrMapping, LDAPService ldapService, ADSearchBySID ad) {
        super(ldapAttrMapping, ldapService);
        this.adSearch = ad;
    }

    @Override
    public Collection findGroupByMembership(String userName, String membershipType) throws Exception {
        return this.findGroups(userName, membershipType);
    }

    @Override
    public Collection findGroupsOfUser(String userName) throws Exception {
        return this.findGroups(userName, null);
    }

    private Collection findGroups(String userName, String type) throws Exception {
        LdapContext ctx = this.ldapService_.getLdapContext();
        ArrayList<Group> list = new ArrayList<Group>();
        String userDN = this.getDNFromUsername(userName);
        if (userDN == null) {
            return list;
        }
        String filter = this.ldapAttrMapping_.userObjectClassFilter;
        String[] retAttrs = new String[]{"tokenGroups"};
        SearchControls constraints = new SearchControls();
        constraints.setSearchScope(0);
        constraints.setReturningAttributes(retAttrs);
        NamingEnumeration<SearchResult> results = ctx.search(userDN, filter, constraints);
        while (results.hasMore()) {
            SearchResult sr = results.next();
            Attributes attrs = sr.getAttributes();
            Attribute attr = attrs.get("tokenGroups");
            for (int x = 0; x < attr.size(); ++x) {
                Group group;
                byte[] SID = (byte[])attr.get(x);
                String membershipDN = this.adSearch.findMembershipDNBySID(SID, this.ldapAttrMapping_.groupsURL, type);
                if (membershipDN == null || (group = this.getGroupFromMembershipDN(membershipDN)) == null || this.checkExist(group, list)) continue;
                list.add(group);
            }
        }
        return list;
    }

    public boolean checkExist(Group group, List<Group> list) {
        for (Group ele : list) {
            if (!ele.getId().equals(group.getId())) continue;
            return true;
        }
        return false;
    }
}

