/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.organization.ldap;

import java.util.ArrayList;
import java.util.Collection;
import javax.naming.NamingEnumeration;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import javax.naming.directory.SearchControls;
import javax.naming.directory.SearchResult;
import javax.naming.ldap.LdapContext;
import org.exoplatform.services.ldap.LDAPService;
import org.exoplatform.services.organization.Group;
import org.exoplatform.services.organization.Membership;
import org.exoplatform.services.organization.impl.MembershipImpl;
import org.exoplatform.services.organization.ldap.ADSearchBySID;
import org.exoplatform.services.organization.ldap.LDAPAttributeMapping;
import org.exoplatform.services.organization.ldap.MembershipDAOImpl;

public class ADMembershipDAOImpl
extends MembershipDAOImpl {
    private ADSearchBySID adSearch;

    public ADMembershipDAOImpl(LDAPAttributeMapping ldapAttrMapping, LDAPService ldapService, ADSearchBySID ad) {
        super(ldapAttrMapping, ldapService);
        this.adSearch = ad;
    }

    public Membership findMembershipByUserGroupAndType(String userName, String groupId, String type) throws Exception {
        String groupDN = this.getGroupDNFromGroupId(groupId);
        ArrayList memberships = (ArrayList)this.findMemberships(userName, groupDN, type);
        if (memberships.size() > 0) {
            return (MembershipImpl)memberships.get(0);
        }
        return null;
    }

    public Collection findMembershipsByUser(String userName) throws Exception {
        ArrayList list = (ArrayList)this.findMemberships(userName, this.ldapAttrMapping_.groupsURL, null);
        return list;
    }

    public Collection findMembershipsByUserAndGroup(String userName, String groupId) throws Exception {
        String groupDN = this.getGroupDNFromGroupId(groupId);
        return (ArrayList)this.findMemberships(userName, groupDN, null);
    }

    private Collection findMemberships(String userName, String groupId, String type) throws Exception {
        LdapContext ctx = this.ldapService_.getLdapContext();
        ArrayList<Membership> list = new ArrayList<Membership>();
        String userDN = this.getDNFromUsername(userName);
        if (userDN == null) {
            return list;
        }
        String filter = this.ldapAttrMapping_.userObjectClassFilter;
        String[] retAttrs = new String[]{"tokenGroups"};
        SearchControls constraints = new SearchControls();
        constraints.setSearchScope(0);
        constraints.setReturningAttributes(retAttrs);
        NamingEnumeration<SearchResult> results = ctx.search(userDN, filter, constraints);
        while (results.hasMore()) {
            SearchResult sr = results.next();
            Attributes attrs = sr.getAttributes();
            Attribute attr = attrs.get("tokenGroups");
            for (int x = 0; x < attr.size(); ++x) {
                byte[] SID = (byte[])attr.get(x);
                String membershipDN = this.adSearch.findMembershipDNBySID(SID, groupId, type);
                if (membershipDN == null) continue;
                list.add(this.createMembershipObject(membershipDN, userName, type));
            }
        }
        return list;
    }

    private Membership createMembershipObject(String dn, String user, String type) throws Exception {
        Group group = this.getGroupFromMembershipDN(dn);
        if (type == null) {
            type = this.explodeDN(dn, true)[0];
        }
        MembershipImpl membership = new MembershipImpl();
        membership.setId(user + "," + type + "," + group.getId());
        membership.setUserName(user);
        membership.setMembershipType(type);
        membership.setGroupId(group.getId());
        return membership;
    }
}

