/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.organization.ldap;

import javax.naming.CompositeName;
import javax.naming.Name;
import javax.naming.NameParser;
import javax.naming.NamingEnumeration;
import javax.naming.directory.SearchControls;
import javax.naming.directory.SearchResult;
import javax.naming.ldap.LdapContext;
import org.exoplatform.services.ldap.LDAPService;
import org.exoplatform.services.organization.ldap.LDAPAttributeMapping;

public class ADSearchBySID {
    protected LDAPAttributeMapping ldapAttrMapping_;
    protected LDAPService ldapService_;

    public ADSearchBySID(LDAPAttributeMapping ldapAttrMapping, LDAPService ldapService) {
        this.ldapAttrMapping_ = ldapAttrMapping;
        this.ldapService_ = ldapService;
    }

    public String findMembershipDNBySID(byte[] sid, String baseDN, String scopedRole) throws Exception {
        LdapContext ctx = this.ldapService_.getLdapContext();
        SearchControls constraints = new SearchControls();
        constraints.setSearchScope(2);
        constraints.setReturningAttributes(new String[]{""});
        constraints.setDerefLinkFlag(true);
        NamingEnumeration<SearchResult> answer = scopedRole == null ? ctx.search(baseDN, "objectSid={0}", new Object[]{sid}, constraints) : ctx.search(baseDN, "(& (objectSid={0}) (" + this.ldapAttrMapping_.membershipTypeRoleNameAttr + "={1}))", new Object[]{sid, scopedRole}, constraints);
        if (answer.hasMoreElements()) {
            SearchResult sr = answer.next();
            NameParser parser = ctx.getNameParser("");
            Name entryName = parser.parse(new CompositeName(sr.getName()).get(0));
            return entryName + "," + baseDN;
        }
        return null;
    }
}

