/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.organization.ldap;

import javax.naming.directory.Attributes;
import javax.naming.directory.BasicAttribute;
import javax.naming.directory.ModificationItem;
import org.exoplatform.services.ldap.LDAPService;
import org.exoplatform.services.organization.User;
import org.exoplatform.services.organization.ldap.LDAPAttributeMapping;
import org.exoplatform.services.organization.ldap.LDAPUserPageList;
import org.exoplatform.services.organization.ldap.UserDAOImpl;

public class ADUserDAOImpl
extends UserDAOImpl {
    int UF_ACCOUNTDISABLE = 2;
    int UF_PASSWD_NOTREQD = 32;
    int UF_NORMAL_ACCOUNT = 512;
    int UF_PASSWORD_EXPIRED = 0x800000;

    public ADUserDAOImpl(LDAPAttributeMapping ldapAttrMapping, LDAPService ldapService) {
        super(ldapAttrMapping, ldapService);
        LDAPUserPageList.SEARCH_CONTROL = true;
    }

    public void createUser(User user, boolean broadcast) throws Exception {
        String userDN = "cn=" + user.getUserName() + "," + this.ldapAttrMapping_.userURL;
        Attributes attrs = this.ldapAttrMapping_.userToAttributes(user);
        attrs.put("userAccountControl", Integer.toString(this.UF_NORMAL_ACCOUNT + this.UF_PASSWD_NOTREQD + this.UF_PASSWORD_EXPIRED + this.UF_ACCOUNTDISABLE));
        attrs.remove(this.ldapAttrMapping_.userPassword);
        if (broadcast) {
            this.preSave(user, true);
        }
        this.ldapService_.getLdapContext().createSubcontext(userDN, attrs);
        if (broadcast) {
            this.postSave(user, true);
        }
        this.saveUserPassword(user, userDN);
    }

    void saveUserPassword(User user, String userDN) throws Exception {
        Object v = this.ldapService_.getLdapContext().getEnvironment().get("java.naming.security.protocol");
        if (v == null) {
            return;
        }
        String security = String.valueOf(v);
        if (!security.equalsIgnoreCase("ssl")) {
            return;
        }
        String newQuotedPassword = "\"" + user.getPassword() + "\"";
        byte[] newUnicodePassword = newQuotedPassword.getBytes("UTF-16LE");
        ModificationItem[] mods = new ModificationItem[]{new ModificationItem(2, new BasicAttribute(this.ldapAttrMapping_.userPassword, newUnicodePassword)), new ModificationItem(2, new BasicAttribute("userAccountControl", Integer.toString(this.UF_NORMAL_ACCOUNT + this.UF_PASSWORD_EXPIRED)))};
        this.ldapService_.getLdapContext().modifyAttributes(userDN, mods);
    }
}

