/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.organization.ldap;

import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import javax.naming.Name;
import javax.naming.NameParser;
import javax.naming.NamingEnumeration;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import javax.naming.directory.SearchControls;
import javax.naming.directory.SearchResult;
import javax.naming.ldap.LdapContext;
import org.exoplatform.services.ldap.LDAPService;
import org.exoplatform.services.organization.Group;
import org.exoplatform.services.organization.User;
import org.exoplatform.services.organization.impl.GroupImpl;
import org.exoplatform.services.organization.ldap.LDAPAttributeMapping;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BaseDAO {
    protected LDAPAttributeMapping ldapAttrMapping_;
    protected LDAPService ldapService_;
    private NameParser parser;

    public BaseDAO(LDAPAttributeMapping ldapAttrMapping, LDAPService ldapService) {
        this.ldapAttrMapping_ = ldapAttrMapping;
        this.ldapService_ = ldapService;
    }

    protected String getGroupDNFromGroupId(String groupId) {
        StringBuilder buffer = new StringBuilder();
        String[] groupParts = groupId.split("/");
        for (int x = groupParts.length - 1; x > 0; --x) {
            buffer.append("ou=" + groupParts[x] + ", ");
        }
        buffer.append(this.ldapAttrMapping_.groupsURL);
        return buffer.toString();
    }

    protected List<Object> getAttributes(Attributes attributes, String attribute) {
        ArrayList<Object> results = new ArrayList<Object>();
        try {
            if (attributes == null) {
                return results;
            }
            Attribute attr = attributes.get(attribute);
            for (int x = 0; x < attr.size(); ++x) {
                results.add(attr.get(x));
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        return results;
    }

    protected Group getGroupFromMembershipDN(String membershipDN) throws Exception {
        String[] membershipParts = this.explodeDN(membershipDN, false);
        StringBuffer buffer = new StringBuffer();
        for (int x = 1; x < membershipParts.length; ++x) {
            if (x == membershipParts.length - 1) {
                buffer.append(membershipParts[x]);
                continue;
            }
            buffer.append(membershipParts[x] + ",");
        }
        Group group = this.getGroupByDN(buffer.toString());
        return group;
    }

    protected Group getGroupByDN(String groupDN) throws Exception {
        LdapContext ctx = this.ldapService_.getLdapContext();
        StringBuffer idBuffer = new StringBuffer();
        String parentId = null;
        String[] baseParts = this.explodeDN(this.ldapAttrMapping_.groupsURL, true);
        String[] membershipParts = this.explodeDN(groupDN, true);
        for (int x = membershipParts.length - baseParts.length - 1; x > -1; --x) {
            idBuffer.append("/" + membershipParts[x]);
            if (x != 1) continue;
            parentId = idBuffer.toString();
        }
        if (idBuffer == null) {
            return null;
        }
        Attributes attrs = ctx.getAttributes(groupDN);
        GroupImpl group = new GroupImpl();
        group.setGroupName(membershipParts[0]);
        group.setId(idBuffer.toString());
        group.setDescription(this.ldapAttrMapping_.getAttributeValueAsString(attrs, "description"));
        group.setLabel(this.ldapAttrMapping_.getAttributeValueAsString(attrs, "l"));
        group.setParentId(parentId);
        return group;
    }

    protected String[] explodeDN(String nameDN, boolean removeTypes) throws Exception {
        if (this.parser == null) {
            this.parser = this.ldapService_.getLdapContext().getNameParser("");
        }
        Name dn = this.parser.parse(nameDN);
        Enumeration<String> enumeration = dn.getAll();
        ArrayList<String> list = new ArrayList<String>();
        while (enumeration.hasMoreElements()) {
            String ldap = enumeration.nextElement();
            if (removeTypes) {
                int position = ldap.indexOf("=");
                String value = ldap.substring(position + 1);
                list.add(0, value);
                continue;
            }
            list.add(0, ldap);
        }
        String[] explodedDN = new String[list.size()];
        list.toArray(explodedDN);
        return explodedDN;
    }

    protected User getUserFromUsername(String username) throws Exception {
        NamingEnumeration<SearchResult> answer = this.findUser(username, true);
        if (answer.hasMoreElements()) {
            String userDN = answer.next().getNameInNamespace();
            return this.ldapAttrMapping_.attributesToUser(this.ldapService_.getLdapContext().getAttributes(userDN));
        }
        return null;
    }

    protected String getDNFromUsername(String username) throws Exception {
        try {
            String userDN = this.ldapAttrMapping_.userDNKey + "=" + username + "," + this.ldapAttrMapping_.userURL;
            Object obj = this.ldapService_.getLdapContext().lookup(userDN);
            if (obj != null) {
                return userDN;
            }
        }
        catch (Exception exp) {
            // empty catch block
        }
        NamingEnumeration<SearchResult> answer = this.findUser(username, false);
        if (answer.hasMoreElements()) {
            return answer.next().getNameInNamespace();
        }
        return null;
    }

    private NamingEnumeration<SearchResult> findUser(String username, boolean hasAttribute) throws Exception {
        SearchControls constraints = new SearchControls();
        constraints.setSearchScope(2);
        if (!hasAttribute) {
            constraints.setReturningAttributes(new String[]{""});
            constraints.setDerefLinkFlag(true);
        }
        String filter = "(&(" + this.ldapAttrMapping_.userUsernameAttr + "=" + username + ")";
        filter = filter + "(" + this.ldapAttrMapping_.userObjectClassFilter + "))";
        return this.ldapService_.getLdapContext().search(this.ldapAttrMapping_.baseURL, filter, constraints);
    }

    protected void removeAllSubtree(LdapContext context, String dn) throws Exception {
        SearchControls constraints = new SearchControls();
        constraints.setSearchScope(1);
        NamingEnumeration<SearchResult> results = context.search(dn, "(objectclass=*)", constraints);
        while (results.hasMore()) {
            SearchResult sr = results.next();
            this.removeAllSubtree(context, sr.getNameInNamespace());
        }
        context.destroySubcontext(dn);
    }

    public String escapeDN(String dn) {
        if (dn == null) {
            return dn;
        }
        StringBuilder buf = new StringBuilder(dn.length());
        block7: for (int i = 0; i < dn.length(); ++i) {
            char c = dn.charAt(i);
            switch (c) {
                case '\\': {
                    buf.append("\\5c");
                    continue block7;
                }
                case '*': {
                    buf.append("\\2a");
                    continue block7;
                }
                case '(': {
                    buf.append("\\28");
                    continue block7;
                }
                case ')': {
                    buf.append("\\29");
                    continue block7;
                }
                case '\u0000': {
                    buf.append("\\00");
                    continue block7;
                }
                default: {
                    buf.append(c);
                }
            }
        }
        return buf.toString();
    }
}

