/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.organization.ldap;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.naming.CompositeName;
import javax.naming.Name;
import javax.naming.NameNotFoundException;
import javax.naming.NameParser;
import javax.naming.NamingEnumeration;
import javax.naming.directory.Attributes;
import javax.naming.directory.BasicAttribute;
import javax.naming.directory.ModificationItem;
import javax.naming.directory.SearchControls;
import javax.naming.directory.SearchResult;
import javax.naming.ldap.LdapContext;
import org.exoplatform.services.ldap.LDAPService;
import org.exoplatform.services.organization.Group;
import org.exoplatform.services.organization.GroupEventListener;
import org.exoplatform.services.organization.GroupHandler;
import org.exoplatform.services.organization.impl.GroupImpl;
import org.exoplatform.services.organization.ldap.BaseDAO;
import org.exoplatform.services.organization.ldap.LDAPAttributeMapping;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GroupDAOImpl
extends BaseDAO
implements GroupHandler {
    protected List<GroupEventListener> listeners_ = new ArrayList<GroupEventListener>(3);

    public GroupDAOImpl(LDAPAttributeMapping ldapAttrMapping, LDAPService ldapService) {
        super(ldapAttrMapping, ldapService);
    }

    public void addGroupEventListener(GroupEventListener listener) {
        this.listeners_.add(listener);
    }

    public final Group createGroupInstance() {
        return new GroupImpl();
    }

    public void createGroup(Group group, boolean broadcast) throws Exception {
        this.addChild(null, group, broadcast);
    }

    public void addChild(Group parent, Group child, boolean broadcast) throws Exception {
        this.setId(parent, child);
        String searchBase = this.createSubDN(parent);
        String groupDN = "ou=" + child.getGroupName() + "," + searchBase;
        String filter = "ou=" + child.getGroupName();
        SearchControls constraints = new SearchControls();
        constraints.setSearchScope(1);
        LdapContext ctx = this.ldapService_.getLdapContext();
        NamingEnumeration<SearchResult> results = ctx.search(searchBase, filter, constraints);
        if (results.hasMore()) {
            return;
        }
        GroupImpl group = (GroupImpl)child;
        if (broadcast) {
            this.preSave(group, true);
        }
        ctx.createSubcontext(groupDN, this.ldapAttrMapping_.groupToAttributes(child));
        this.postSave(group, true);
    }

    public void saveGroup(Group group, boolean broadcast) throws Exception {
        LdapContext ctx = this.ldapService_.getLdapContext();
        Group parent = this.findGroupById(group.getParentId());
        this.setId(parent, group);
        String groupDN = "ou=" + group.getGroupName() + "," + this.createSubDN(parent);
        ArrayList<ModificationItem> modifications = new ArrayList<ModificationItem>();
        ModificationItem mod = new ModificationItem(2, new BasicAttribute(this.ldapAttrMapping_.ldapDescriptionAttr, group.getDescription()));
        modifications.add(mod);
        mod = new ModificationItem(2, new BasicAttribute("l", group.getLabel()));
        modifications.add(mod);
        ModificationItem[] mods = new ModificationItem[modifications.size()];
        modifications.toArray(mods);
        if (broadcast) {
            this.preSave(group, true);
        }
        NameParser parser = ctx.getNameParser("");
        Name name = parser.parse(groupDN);
        ctx.modifyAttributes(name, mods);
        if (broadcast) {
            this.postSave(group, true);
        }
    }

    public Group removeGroup(Group group, boolean broadcast) throws Exception {
        LdapContext ctx = this.ldapService_.getLdapContext();
        String filter = "ou=" + group.getGroupName();
        String searchBase = this.createSubDN(group.getParentId());
        SearchControls constraints = new SearchControls();
        constraints.setSearchScope(1);
        NamingEnumeration<SearchResult> results = ctx.search(searchBase, filter, constraints);
        if (!results.hasMore()) {
            return group;
        }
        SearchResult sr = results.next();
        NameParser parser = ctx.getNameParser("");
        Name entryName = parser.parse(new CompositeName(sr.getName()).get(0));
        String groupDN = entryName + "," + searchBase;
        group = this.getGroupByDN(groupDN);
        if (group == null) {
            return group;
        }
        if (broadcast) {
            this.preDelete(group);
        }
        this.removeAllSubtree(ctx, groupDN);
        if (broadcast) {
            this.postDelete(group);
        }
        return group;
    }

    public Collection findGroupByMembership(String userName, String membershipType) throws Exception {
        ArrayList<Group> groups = new ArrayList<Group>();
        LdapContext ctx = this.ldapService_.getLdapContext();
        String filter = "(&(" + this.ldapAttrMapping_.membershipTypeMemberValue + "=" + this.getDNFromUsername(userName) + ")(" + this.ldapAttrMapping_.membershipTypeRoleNameAttr + "=" + membershipType + "))";
        SearchControls constraints = new SearchControls();
        constraints.setSearchScope(2);
        NamingEnumeration<SearchResult> results = ctx.search(this.ldapAttrMapping_.groupsURL, filter, constraints);
        while (results.hasMore()) {
            SearchResult sr = results.next();
            NameParser parser = ctx.getNameParser("");
            Name entryName = parser.parse(new CompositeName(sr.getName()).get(0));
            String entryName_ = String.valueOf(entryName).substring(entryName.getSuffix(1).toString().length() + 1);
            String groupDN = entryName_ + "," + this.ldapAttrMapping_.groupsURL;
            Group group = this.getGroupByDN(groupDN);
            if (group == null) continue;
            this.addGroup(groups, group);
        }
        return groups;
    }

    public Group findGroupById(String groupId) throws Exception {
        if (groupId == null) {
            return null;
        }
        String parentId_ = null;
        LdapContext ctx = this.ldapService_.getLdapContext();
        StringBuffer buffer = new StringBuffer();
        String[] groupIdParts = groupId.split("/");
        for (int x = 1; x < groupIdParts.length; ++x) {
            buffer.append("/" + groupIdParts[x]);
            if (x != groupIdParts.length - 2) continue;
            parentId_ = buffer.toString();
        }
        String groupDN = this.getGroupDNFromGroupId(groupId);
        try {
            Attributes attrs = ctx.getAttributes(groupDN);
            Group group = this.ldapAttrMapping_.attributesToGroup(attrs);
            ((GroupImpl)group).setId(groupId);
            ((GroupImpl)group).setParentId(parentId_);
            return group;
        }
        catch (NameNotFoundException e) {
            return null;
        }
    }

    public Collection getAllGroups() throws Exception {
        ArrayList<Group> groups = new ArrayList<Group>();
        LdapContext ctx = this.ldapService_.getLdapContext();
        SearchControls constraints = new SearchControls();
        constraints.setSearchScope(2);
        NamingEnumeration<SearchResult> results = null;
        try {
            results = ctx.search(this.ldapAttrMapping_.groupsURL, "(ou=*)", constraints);
        }
        catch (Exception exp) {
            return groups;
        }
        while (results.hasMore()) {
            Name entryName;
            String groupDN;
            Group group;
            SearchResult sr = results.next();
            NameParser parser = ctx.getNameParser("");
            CompositeName name = new CompositeName(sr.getName());
            if (name.size() <= 0 || (group = this.getGroupByDN(groupDN = (entryName = parser.parse(name.get(0))) + "," + this.ldapAttrMapping_.groupsURL)) == null) continue;
            this.addGroup(groups, group);
        }
        return groups;
    }

    public Collection findGroups(Group parent) throws Exception {
        ArrayList<Group> groups = new ArrayList<Group>();
        String groupsBaseDN = this.ldapAttrMapping_.groupsURL;
        StringBuffer buffer = new StringBuffer();
        if (parent != null) {
            String[] dnParts = parent.getId().split("/");
            for (int x = dnParts.length - 1; x > 0; --x) {
                buffer.append("ou=" + dnParts[x] + ", ");
            }
        }
        buffer.append(groupsBaseDN);
        LdapContext ctx = this.ldapService_.getLdapContext();
        String searchBase = buffer.toString();
        String filter = this.ldapAttrMapping_.groupObjectClassFilter;
        SearchControls constraints = new SearchControls();
        constraints.setSearchScope(1);
        NamingEnumeration<SearchResult> results = null;
        try {
            results = ctx.search(searchBase, filter, constraints);
        }
        catch (Exception exp) {
            return groups;
        }
        while (results.hasMore()) {
            Name entryName;
            String groupDN;
            Group group;
            SearchResult sr = results.next();
            NameParser parser = ctx.getNameParser("");
            CompositeName name = new CompositeName(sr.getName());
            if (name.size() <= 0 || (group = this.getGroupByDN(groupDN = (entryName = parser.parse(name.get(0))) + "," + searchBase)) == null) continue;
            this.addGroup(groups, group);
        }
        return groups;
    }

    public Collection findGroupsOfUser(String user) throws Exception {
        ArrayList<Group> groups = new ArrayList<Group>();
        LdapContext ctx = this.ldapService_.getLdapContext();
        String userDN = this.getDNFromUsername(user);
        String searchBase = this.ldapAttrMapping_.groupsURL;
        String filter = this.ldapAttrMapping_.membershipTypeMemberValue + "=" + this.escapeDN(userDN);
        SearchControls constraints = new SearchControls();
        constraints.setSearchScope(2);
        NamingEnumeration<SearchResult> results = ctx.search(searchBase, filter, constraints);
        while (results.hasMore()) {
            SearchResult sr = results.next();
            NameParser parser = ctx.getNameParser("");
            CompositeName name = new CompositeName(sr.getName());
            if (name.size() < 1) break;
            Name entryName = parser.parse(name.get(0));
            String groupDN = entryName + "," + searchBase;
            Group group = this.getGroupFromMembershipDN(groupDN);
            if (group == null) continue;
            this.addGroup(groups, group);
        }
        return groups;
    }

    protected void addGroup(List<Group> groups, Group g) {
        for (int i = 0; i < groups.size(); ++i) {
            if (!groups.get(i).getId().equals(g.getId())) continue;
            return;
        }
        groups.add(g);
    }

    protected void preSave(Group group, boolean isNew) throws Exception {
        for (GroupEventListener listener : this.listeners_) {
            listener.preSave(group, isNew);
        }
    }

    protected void postSave(Group group, boolean isNew) throws Exception {
        for (GroupEventListener listener : this.listeners_) {
            listener.postSave(group, isNew);
        }
    }

    protected void preDelete(Group group) throws Exception {
        for (GroupEventListener listener : this.listeners_) {
            listener.preDelete(group);
        }
    }

    protected void postDelete(Group group) throws Exception {
        for (GroupEventListener listener : this.listeners_) {
            listener.postDelete(group);
        }
    }

    protected String createSubDN(Group parent) {
        if (parent == null) {
            return this.createSubDN("");
        }
        return this.createSubDN(parent.getId());
    }

    protected String createSubDN(String parentId) {
        StringBuffer buffer = new StringBuffer();
        if (parentId != null && parentId.length() > 0) {
            String[] dnParts = parentId.split("/");
            for (int x = dnParts.length - 1; x > 0; --x) {
                buffer.append("ou=" + dnParts[x] + ", ");
            }
        }
        buffer.append(this.ldapAttrMapping_.groupsURL);
        return buffer.toString();
    }

    protected void setId(Group parent, Group g) {
        GroupImpl group = (GroupImpl)g;
        if (parent == null) {
            group.setId("/" + group.getGroupName());
            return;
        }
        group.setId(parent.getId() + "/" + group.getGroupName());
        group.setParentId(parent.getId());
    }
}

