/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.organization.ldap;

import java.util.Calendar;
import java.util.Date;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import javax.naming.directory.BasicAttributes;
import org.exoplatform.services.ldap.ObjectClassAttribute;
import org.exoplatform.services.organization.Group;
import org.exoplatform.services.organization.Membership;
import org.exoplatform.services.organization.MembershipType;
import org.exoplatform.services.organization.User;
import org.exoplatform.services.organization.UserProfile;
import org.exoplatform.services.organization.impl.GroupImpl;
import org.exoplatform.services.organization.impl.MembershipTypeImpl;
import org.exoplatform.services.organization.impl.UserImpl;
import org.exoplatform.services.organization.impl.UserProfileData;

public class LDAPAttributeMapping {
    String userLDAPClasses;
    String profileLDAPClasses;
    String groupLDAPClasses;
    String membershipTypeLDAPClasses;
    String membershipLDAPClasses;
    static String[] USER_LDAP_CLASSES;
    static String[] PROFILE_LDAP_CLASSES;
    static String[] GROUP_LDAP_CLASSES;
    static String[] MEMBERSHIPTYPE_LDAP_CLASSES;
    static String[] MEMBERSHIP_LDAP_CLASSES;
    String baseURL;
    String groupsURL;
    String membershipTypeURL;
    String userURL;
    String profileURL;
    String userDNKey;
    String userAuthenticationAttr;
    String userUsernameAttr;
    String userPassword;
    String userFirstNameAttr;
    String userLastNameAttr;
    String userDisplayNameAttr;
    String userMailAttr;
    String userObjectClassFilter;
    String membershipTypeMemberValue;
    String membershipTypeRoleNameAttr;
    String membershipTypeNameAttr;
    String membershipTypeObjectClassFilter;
    String membershiptypeObjectClass;
    String groupObjectClass;
    String groupObjectClassFilter;
    String membershipObjectClass;
    String membershipObjectClassFilter;
    String ldapCreatedTimeStampAttr;
    String ldapModifiedTimeStampAttr;
    String ldapDescriptionAttr;

    public final Attributes userToAttributes(User user) {
        BasicAttributes attrs = new BasicAttributes();
        if (USER_LDAP_CLASSES == null) {
            USER_LDAP_CLASSES = this.userLDAPClasses.split(",");
        }
        attrs.put((Attribute)new ObjectClassAttribute(USER_LDAP_CLASSES));
        attrs.put("cn", user.getUserName());
        attrs.put(this.userDisplayNameAttr, user.getFullName());
        attrs.put(this.userUsernameAttr, user.getUserName());
        attrs.put(this.userPassword, user.getPassword());
        attrs.put(this.userLastNameAttr, user.getLastName());
        attrs.put(this.userFirstNameAttr, user.getFirstName());
        attrs.put(this.userMailAttr, user.getEmail());
        attrs.put(this.ldapDescriptionAttr, "Account for " + user.getFullName());
        return attrs;
    }

    public final User attributesToUser(Attributes attrs) throws Exception {
        if (attrs == null || attrs.size() == 0) {
            return null;
        }
        UserImpl user = new UserImpl();
        user.setUserName(this.getAttributeValueAsString(attrs, this.userUsernameAttr));
        user.setLastName(this.getAttributeValueAsString(attrs, this.userLastNameAttr));
        user.setFirstName(this.getAttributeValueAsString(attrs, this.userFirstNameAttr));
        user.setFullName(this.getAttributeValueAsString(attrs, this.userDisplayNameAttr));
        user.setEmail(this.getAttributeValueAsString(attrs, this.userMailAttr));
        user.setPassword(this.getAttributeValueAsString(attrs, this.userPassword));
        user.setCreatedDate(Calendar.getInstance().getTime());
        user.setLastLoginTime(Calendar.getInstance().getTime());
        return user;
    }

    public final Attributes groupToAttributes(Group group) {
        String lbl;
        BasicAttributes attrs = new BasicAttributes();
        if (GROUP_LDAP_CLASSES == null) {
            GROUP_LDAP_CLASSES = this.groupLDAPClasses.split(",");
        }
        attrs.put((Attribute)new ObjectClassAttribute(GROUP_LDAP_CLASSES));
        attrs.put("ou", group.getGroupName());
        String desc = group.getDescription();
        if (desc != null && desc.length() > 0) {
            attrs.put("description", desc);
        }
        if ((lbl = group.getLabel()) != null && lbl.length() > 0) {
            attrs.put("l", lbl);
        }
        return attrs;
    }

    public final Group attributesToGroup(Attributes attrs) throws Exception {
        if (attrs == null || attrs.size() == 0) {
            return null;
        }
        GroupImpl group = new GroupImpl();
        group.setGroupName(this.getAttributeValueAsString(attrs, "ou"));
        group.setDescription(this.getAttributeValueAsString(attrs, "description"));
        group.setLabel(this.getAttributeValueAsString(attrs, "l"));
        return group;
    }

    public final Attributes membershipTypeToAttributes(MembershipType mt) {
        BasicAttributes attrs = new BasicAttributes();
        if (MEMBERSHIPTYPE_LDAP_CLASSES == null) {
            MEMBERSHIPTYPE_LDAP_CLASSES = this.membershipTypeLDAPClasses.split(",");
        }
        attrs.put((Attribute)new ObjectClassAttribute(MEMBERSHIPTYPE_LDAP_CLASSES));
        attrs.put(this.membershipTypeNameAttr, mt.getName());
        String desc = mt.getDescription();
        if (desc != null && desc.length() > 0) {
            attrs.put("description", desc);
        }
        return attrs;
    }

    public final MembershipType attributesToMembershipType(Attributes attrs) {
        if (attrs == null || attrs.size() == 0) {
            return null;
        }
        MembershipTypeImpl m = new MembershipTypeImpl();
        m.setName(this.getAttributeValueAsString(attrs, this.membershipTypeNameAttr));
        m.setDescription(this.getAttributeValueAsString(attrs, "description"));
        m.setCreatedDate(new Date());
        m.setModifiedDate(new Date());
        return m;
    }

    public final Attributes membershipToAttributes(Membership m, String userDN) {
        BasicAttributes attrs = new BasicAttributes();
        if (MEMBERSHIP_LDAP_CLASSES == null) {
            MEMBERSHIP_LDAP_CLASSES = this.membershipLDAPClasses.split(",");
        }
        attrs.put((Attribute)new ObjectClassAttribute(MEMBERSHIP_LDAP_CLASSES));
        attrs.put(this.membershipTypeRoleNameAttr, m.getMembershipType());
        attrs.put(this.membershipTypeMemberValue, userDN);
        return attrs;
    }

    public final Attributes profileToAttributes(UserProfile profile) {
        BasicAttributes attrs = new BasicAttributes();
        if (PROFILE_LDAP_CLASSES == null) {
            PROFILE_LDAP_CLASSES = this.profileLDAPClasses.split(",");
        }
        attrs.put((Attribute)new ObjectClassAttribute(PROFILE_LDAP_CLASSES));
        attrs.put("sn", profile.getUserName());
        UserProfileData upd = new UserProfileData();
        upd.setUserProfile(profile);
        attrs.put(this.ldapDescriptionAttr, upd.getProfile());
        return attrs;
    }

    public final UserProfileData attributesToProfile(Attributes attrs) {
        if (attrs == null || attrs.size() == 0) {
            return null;
        }
        UserProfileData upd = new UserProfileData();
        upd.setProfile(this.getAttributeValueAsString(attrs, this.ldapDescriptionAttr));
        return upd;
    }

    public final String getAttributeValueAsString(Attributes attributes, String name) {
        if (attributes == null) {
            return "";
        }
        Attribute attr = attributes.get(name);
        if (attr == null) {
            return "";
        }
        try {
            Object obj = attr.get();
            if (obj instanceof byte[]) {
                return new String((byte[])obj);
            }
            return (String)obj;
        }
        catch (Exception e) {
            return "";
        }
    }
}

