/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.organization.ldap;

import java.util.ArrayList;
import java.util.List;
import javax.naming.NameNotFoundException;
import javax.naming.NamingEnumeration;
import javax.naming.directory.SearchControls;
import javax.naming.directory.SearchResult;
import javax.naming.ldap.Control;
import javax.naming.ldap.LdapContext;
import javax.naming.ldap.PagedResultsControl;
import javax.naming.ldap.PagedResultsResponseControl;
import javax.naming.ldap.SortControl;
import org.exoplatform.commons.utils.PageList;
import org.exoplatform.services.ldap.LDAPService;
import org.exoplatform.services.organization.User;
import org.exoplatform.services.organization.ldap.LDAPAttributeMapping;

public class LDAPUserPageList
extends PageList {
    private String searchBase_;
    private String filter_;
    private LDAPService ldapService_;
    private LDAPAttributeMapping ldapAttrMapping_;
    static boolean SEARCH_CONTROL = false;

    public LDAPUserPageList(LDAPAttributeMapping ldapAttrMapping, LDAPService ldapService, String searchBase, String filter, int pageSize) throws Exception {
        super(pageSize);
        this.ldapAttrMapping_ = ldapAttrMapping;
        this.ldapService_ = ldapService;
        this.searchBase_ = searchBase;
        this.filter_ = filter;
        try {
            int size = this.getResultSize();
            this.setAvailablePage(size);
        }
        catch (NameNotFoundException exp) {
            this.setAvailablePage(0);
        }
    }

    protected void populateCurrentPage(int page) throws Exception {
        ArrayList<User> users = new ArrayList<User>();
        PagedResultsControl prc = new PagedResultsControl(this.getPageSize(), true);
        String[] keys = new String[]{this.ldapAttrMapping_.userUsernameAttr};
        SortControl sctl = new SortControl(keys, SEARCH_CONTROL);
        LdapContext ctx = this.ldapService_.getLdapContext();
        ctx.setRequestControls(new Control[]{sctl, prc});
        SearchControls constraints = new SearchControls();
        constraints.setSearchScope(2);
        byte[] cookie = null;
        int counter = 0;
        do {
            ++counter;
            NamingEnumeration<SearchResult> results = ctx.search(this.searchBase_, this.filter_, constraints);
            if (results == null) break;
            while (results.hasMore()) {
                SearchResult result = results.next();
                if (counter != page) continue;
                users.add(this.ldapAttrMapping_.attributesToUser(result.getAttributes()));
            }
            Control[] responseControls = ctx.getResponseControls();
            for (int z = 0; z < responseControls.length; ++z) {
                if (!(responseControls[z] instanceof PagedResultsResponseControl)) continue;
                cookie = ((PagedResultsResponseControl)responseControls[z]).getCookie();
            }
            ctx.setRequestControls(new Control[]{new PagedResultsControl(this.getPageSize(), cookie, true)});
        } while (cookie != null);
        this.currentListPage_ = users;
    }

    private int getResultSize() throws Exception {
        NamingEnumeration<SearchResult> results;
        PagedResultsControl prc = new PagedResultsControl(this.getPageSize(), true);
        String[] keys = new String[]{this.ldapAttrMapping_.userUsernameAttr};
        SortControl sctl = new SortControl(keys, SEARCH_CONTROL);
        LdapContext ctx = this.ldapService_.getLdapContext();
        ctx.setRequestControls(new Control[]{sctl, prc});
        SearchControls constraints = new SearchControls();
        String[] returnedAtts = new String[]{this.ldapAttrMapping_.userUsernameAttr};
        constraints.setReturningAttributes(returnedAtts);
        constraints.setSearchScope(2);
        byte[] cookie = null;
        int counter = -1;
        while ((results = ctx.search(this.searchBase_, this.filter_, constraints)) != null) {
            while (results.hasMore()) {
                ++counter;
                results.next();
            }
            Control[] responseControls = ctx.getResponseControls();
            if (responseControls != null) {
                for (int z = 0; z < responseControls.length; ++z) {
                    if (!(responseControls[z] instanceof PagedResultsResponseControl)) continue;
                    cookie = ((PagedResultsResponseControl)responseControls[z]).getCookie();
                }
                ctx.setRequestControls(new Control[]{new PagedResultsControl(this.getPageSize(), cookie, false)});
            }
            if (cookie != null) continue;
        }
        return counter + 1;
    }

    public List getAll() throws Exception {
        return null;
    }
}

