/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.organization.ldap;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.naming.Name;
import javax.naming.NameNotFoundException;
import javax.naming.NameParser;
import javax.naming.NamingEnumeration;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import javax.naming.directory.BasicAttribute;
import javax.naming.directory.ModificationItem;
import javax.naming.directory.SearchControls;
import javax.naming.directory.SearchResult;
import javax.naming.ldap.LdapContext;
import org.exoplatform.services.ldap.LDAPService;
import org.exoplatform.services.organization.Group;
import org.exoplatform.services.organization.Membership;
import org.exoplatform.services.organization.MembershipEventListener;
import org.exoplatform.services.organization.MembershipHandler;
import org.exoplatform.services.organization.MembershipType;
import org.exoplatform.services.organization.User;
import org.exoplatform.services.organization.impl.MembershipImpl;
import org.exoplatform.services.organization.ldap.BaseDAO;
import org.exoplatform.services.organization.ldap.LDAPAttributeMapping;

public class MembershipDAOImpl
extends BaseDAO
implements MembershipHandler {
    protected List<MembershipEventListener> listeners_ = new ArrayList<MembershipEventListener>(3);

    public MembershipDAOImpl(LDAPAttributeMapping ldapAttrMapping, LDAPService ldapService) {
        super(ldapAttrMapping, ldapService);
    }

    public void addMembershipEventListener(MembershipEventListener listener) {
        this.listeners_.add(listener);
    }

    public final Membership createMembershipInstance() {
        return new MembershipImpl();
    }

    public void createMembership(Membership m, boolean broadcast) throws Exception {
        LdapContext ctx = this.ldapService_.getLdapContext();
        String userDN = this.getDNFromUsername(m.getUserName());
        String groupDN = this.getGroupDNFromGroupId(m.getGroupId());
        String membershipDN = this.ldapAttrMapping_.membershipTypeNameAttr + "=" + m.getMembershipType() + "," + groupDN;
        Attributes attrs = null;
        try {
            attrs = ctx.getAttributes(membershipDN);
        }
        catch (Exception exp) {
            // empty catch block
        }
        if (attrs == null) {
            if (broadcast) {
                this.preSave(m, true);
            }
            ctx.createSubcontext(membershipDN, this.ldapAttrMapping_.membershipToAttributes(m, userDN));
            this.postSave(m, true);
            return;
        }
        List<Object> members = this.getAttributes(attrs, this.ldapAttrMapping_.membershipTypeMemberValue);
        if (members.contains(userDN)) {
            return;
        }
        ModificationItem[] mods = new ModificationItem[]{new ModificationItem(1, new BasicAttribute(this.ldapAttrMapping_.membershipTypeMemberValue, userDN))};
        try {
            this.preSave(m, true);
            ctx.modifyAttributes(membershipDN, mods);
            this.postSave(m, true);
        }
        catch (Exception exp) {
            this.removeMembership(m.getGroupId(), true);
        }
    }

    public void linkMembership(User user, Group group, MembershipType mt, boolean broadcast) throws Exception {
        if (mt == null || group == null) {
            return;
        }
        MembershipImpl membership = new MembershipImpl();
        membership.setMembershipType(mt.getName());
        membership.setUserName(user.getUserName());
        membership.setGroupId(group.getId());
        this.createMembership(membership, broadcast);
    }

    public Membership removeMembership(String id, boolean broadcast) throws Exception {
        MembershipImpl m = new MembershipImpl();
        String[] membershipParts = id.split(",");
        if (membershipParts.length < 3) {
            return null;
        }
        String username = membershipParts[0];
        String membershipType = membershipParts[1];
        String groupId = membershipParts[2];
        m.setGroupId(groupId);
        m.setId(id);
        m.setMembershipType(membershipType);
        m.setUserName(username);
        String userDN = this.getDNFromUsername(username).trim();
        String groupDN = this.getGroupDNFromGroupId(groupId);
        String membershipDN = this.ldapAttrMapping_.membershipTypeNameAttr + "=" + membershipType + ", " + groupDN;
        try {
            LdapContext ctx = this.ldapService_.getLdapContext();
            NameParser parser = ctx.getNameParser("");
            Name dn = parser.parse(membershipDN);
            Attributes attrs = ctx.getAttributes(dn);
            if (attrs == null) {
                return m;
            }
            List<Object> members = this.getAttributes(attrs, this.ldapAttrMapping_.membershipTypeMemberValue);
            boolean remove = false;
            for (int i = 0; i < members.size(); ++i) {
                if (!String.valueOf(members.get(i)).trim().equalsIgnoreCase(userDN)) continue;
                remove = true;
                break;
            }
            if (!remove) {
                return m;
            }
            if (members.size() > 1) {
                ModificationItem[] mods = new ModificationItem[]{new ModificationItem(3, new BasicAttribute(this.ldapAttrMapping_.membershipTypeMemberValue, userDN))};
                if (broadcast) {
                    this.preSave(m, true);
                }
                ctx.modifyAttributes(membershipDN, mods);
                if (broadcast) {
                    this.postSave(m, true);
                }
            } else {
                if (broadcast) {
                    this.preDelete(m);
                }
                ctx.destroySubcontext(membershipDN);
                if (broadcast) {
                    this.postDelete(m);
                }
            }
        }
        catch (NameNotFoundException e) {
            e.printStackTrace();
        }
        return m;
    }

    public Collection removeMembershipByUser(String username, boolean broadcast) throws Exception {
        String userDN = this.getDNFromUsername(username);
        String filter = this.ldapAttrMapping_.membershipTypeMemberValue + "=" + this.escapeDN(userDN);
        SearchControls constraints = new SearchControls();
        constraints.setSearchScope(2);
        LdapContext ctx = this.ldapService_.getLdapContext();
        NamingEnumeration<SearchResult> results = ctx.search(this.ldapAttrMapping_.groupsURL, filter, constraints);
        while (results.hasMore()) {
            SearchResult sr = results.next();
            try {
                Attributes attrs = sr.getAttributes();
                if (attrs.get(this.ldapAttrMapping_.membershipTypeMemberValue).size() > 1) {
                    ModificationItem[] mods = new ModificationItem[]{new ModificationItem(3, new BasicAttribute(this.ldapAttrMapping_.membershipTypeMemberValue, userDN))};
                    ctx.modifyAttributes(sr.getNameInNamespace(), mods);
                    continue;
                }
                ctx.destroySubcontext(sr.getNameInNamespace());
            }
            catch (Exception exp) {
                exp.printStackTrace();
            }
        }
        return new ArrayList();
    }

    public Membership findMembership(String id) throws Exception {
        String[] membershipParts = id.split(",");
        Membership membership = this.findMembershipByUserGroupAndType(membershipParts[0], membershipParts[2], membershipParts[1]);
        return membership;
    }

    public Membership findMembershipByUserGroupAndType(String userName, String groupId, String type) throws Exception {
        String membershipDN = this.ldapAttrMapping_.membershipTypeNameAttr + "=" + type + "," + this.getGroupDNFromGroupId(groupId);
        try {
            LdapContext ctx = this.ldapService_.getLdapContext();
            Attributes attrs = ctx.getAttributes(membershipDN);
            if (attrs == null) {
                return null;
            }
            if (!this.haveUser(attrs, this.getDNFromUsername(userName).trim())) {
                return null;
            }
            return this.createObject(userName, groupId, type);
        }
        catch (NameNotFoundException e) {
            return null;
        }
    }

    public Collection findMembershipsByUserAndGroup(String userName, String groupId) throws Exception {
        ArrayList<MembershipImpl> memberships = new ArrayList<MembershipImpl>();
        String userDN = this.getDNFromUsername(userName);
        if (userDN == null) {
            return memberships;
        }
        userDN = userDN.trim();
        NamingEnumeration<SearchResult> results = null;
        LdapContext ctx = this.ldapService_.getLdapContext();
        try {
            SearchControls constraints = new SearchControls();
            constraints.setSearchScope(1);
            results = ctx.search(this.getGroupDNFromGroupId(groupId), "objectClass=groupOfNames", constraints);
        }
        catch (Exception exp) {
            // empty catch block
        }
        if (results == null) {
            return memberships;
        }
        while (results.hasMore()) {
            SearchResult sr = (SearchResult)results.next();
            if (!this.haveUser(sr.getAttributes(), userDN)) continue;
            memberships.add(this.createObject(userName, groupId, this.explodeDN(sr.getNameInNamespace(), true)[0]));
        }
        return memberships;
    }

    public Collection findMembershipsByUser(String userName) throws Exception {
        ArrayList<MembershipImpl> memberships = new ArrayList<MembershipImpl>();
        String userDN = this.getDNFromUsername(userName);
        if (userDN == null) {
            return memberships;
        }
        String filter = this.ldapAttrMapping_.membershipTypeMemberValue + "=" + this.escapeDN(userDN);
        SearchControls constraints = new SearchControls();
        constraints.setSearchScope(2);
        LdapContext ctx = this.ldapService_.getLdapContext();
        NamingEnumeration<SearchResult> results = null;
        try {
            results = ctx.search(this.ldapAttrMapping_.groupsURL, filter, constraints);
        }
        catch (Exception exp) {
            return memberships;
        }
        if (results == null) {
            return memberships;
        }
        while (results.hasMore()) {
            SearchResult sr = results.next();
            String membershipDN = sr.getNameInNamespace();
            Group group = this.getGroupFromMembershipDN(membershipDN);
            String type = this.explodeDN(membershipDN, true)[0];
            memberships.add(this.createObject(userName, group.getId(), type));
        }
        return memberships;
    }

    public Collection findMembershipsByGroup(Group group) throws Exception {
        ArrayList<MembershipImpl> memberships = new ArrayList<MembershipImpl>();
        LdapContext ctx = this.ldapService_.getLdapContext();
        String groupDN = this.getGroupDNFromGroupId(group.getId());
        SearchControls constraints = new SearchControls();
        constraints.setSearchScope(1);
        NamingEnumeration<SearchResult> results = null;
        try {
            results = ctx.search(groupDN, this.ldapAttrMapping_.membershipObjectClassFilter, constraints);
        }
        catch (Exception exp) {
            return memberships;
        }
        if (results == null || !results.hasMoreElements()) {
            return memberships;
        }
        while (results.hasMoreElements()) {
            SearchResult sr = results.next();
            NameParser parser = ctx.getNameParser("");
            String type = this.explodeDN(sr.getNameInNamespace(), true)[0];
            Attributes attrs = sr.getAttributes();
            Attribute attr = attrs.get(this.ldapAttrMapping_.membershipTypeMemberValue);
            for (int i = 0; i < attr.size(); ++i) {
                String userName = this.explodeDN(String.valueOf(attr.get(i)), true)[0];
                memberships.add(this.createObject(userName, group.getId(), type));
            }
        }
        return memberships;
    }

    private boolean haveUser(Attributes attrs, String userDN) throws Exception {
        if (attrs == null) {
            return false;
        }
        List<Object> members = this.getAttributes(attrs, this.ldapAttrMapping_.membershipTypeMemberValue);
        for (int i = 0; i < members.size(); ++i) {
            if (!String.valueOf(members.get(i)).trim().equalsIgnoreCase(userDN)) continue;
            return true;
        }
        return false;
    }

    private MembershipImpl createObject(String userName, String groupId, String type) throws Exception {
        MembershipImpl membership = new MembershipImpl();
        membership.setGroupId(groupId);
        membership.setUserName(userName);
        membership.setMembershipType(type);
        membership.setId(userName + "," + type + "," + groupId);
        return membership;
    }

    private void postDelete(Membership membership) throws Exception {
        for (MembershipEventListener listener : this.listeners_) {
            listener.postDelete(membership);
        }
    }

    private void preDelete(Membership membership) throws Exception {
        for (MembershipEventListener listener : this.listeners_) {
            listener.preDelete(membership);
        }
    }

    private void postSave(Membership membership, boolean isNew) throws Exception {
        for (MembershipEventListener listener : this.listeners_) {
            listener.postSave(membership, isNew);
        }
    }

    private void preSave(Membership membership, boolean isNew) throws Exception {
        for (MembershipEventListener listener : this.listeners_) {
            listener.preSave(membership, isNew);
        }
    }
}

