/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.organization.ldap;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import javax.naming.NameNotFoundException;
import javax.naming.NamingEnumeration;
import javax.naming.directory.Attributes;
import javax.naming.directory.BasicAttribute;
import javax.naming.directory.ModificationItem;
import javax.naming.directory.SearchControls;
import javax.naming.directory.SearchResult;
import javax.naming.ldap.LdapContext;
import org.exoplatform.services.ldap.LDAPService;
import org.exoplatform.services.organization.MembershipType;
import org.exoplatform.services.organization.MembershipTypeHandler;
import org.exoplatform.services.organization.impl.MembershipTypeImpl;
import org.exoplatform.services.organization.ldap.BaseDAO;
import org.exoplatform.services.organization.ldap.LDAPAttributeMapping;

public class MembershipTypeDAOImpl
extends BaseDAO
implements MembershipTypeHandler {
    public MembershipTypeDAOImpl(LDAPAttributeMapping ldapAttrMapping, LDAPService ldapService) {
        super(ldapAttrMapping, ldapService);
    }

    public final MembershipType createMembershipTypeInstance() {
        return new MembershipTypeImpl();
    }

    public MembershipType createMembershipType(MembershipType mt, boolean broadcast) throws Exception {
        LdapContext ctx = this.ldapService_.getLdapContext();
        String membershipTypeDN = this.ldapAttrMapping_.membershipTypeNameAttr + "=" + mt.getName() + "," + this.ldapAttrMapping_.membershipTypeURL;
        try {
            ctx.getAttributes(membershipTypeDN);
        }
        catch (NameNotFoundException e) {
            Date now = new Date();
            mt.setCreatedDate(now);
            mt.setModifiedDate(now);
            ctx.createSubcontext(membershipTypeDN, this.ldapAttrMapping_.membershipTypeToAttributes(mt));
        }
        return mt;
    }

    public MembershipType saveMembershipType(MembershipType mt, boolean broadcast) throws Exception {
        String membershipTypeDN;
        LdapContext ctx = this.ldapService_.getLdapContext();
        Attributes attrs = ctx.getAttributes(membershipTypeDN = this.ldapAttrMapping_.membershipTypeNameAttr + "=" + mt.getName() + "," + this.ldapAttrMapping_.membershipTypeURL);
        if (attrs == null) {
            return mt;
        }
        String desc = mt.getDescription();
        ModificationItem[] mods = new ModificationItem[]{desc != null && desc.length() > 0 ? new ModificationItem(2, new BasicAttribute("description", mt.getDescription())) : new ModificationItem(3, new BasicAttribute("description", mt.getDescription()))};
        ctx.modifyAttributes(membershipTypeDN, mods);
        return mt;
    }

    public MembershipType removeMembershipType(String name, boolean broadcast) throws Exception {
        MembershipType m = null;
        LdapContext ctx = this.ldapService_.getLdapContext();
        String membershipTypeDN = this.ldapAttrMapping_.membershipTypeNameAttr + "=" + name + "," + this.ldapAttrMapping_.membershipTypeURL;
        try {
            Attributes attrs = ctx.getAttributes(membershipTypeDN);
            if (attrs == null) {
                return m;
            }
            m = this.ldapAttrMapping_.attributesToMembershipType(attrs);
            this.removeMembership(name);
            ctx.destroySubcontext(membershipTypeDN);
        }
        catch (NameNotFoundException e) {
            // empty catch block
        }
        return m;
    }

    private void removeMembership(String name) throws Exception {
        LdapContext ctx = this.ldapService_.getLdapContext();
        SearchControls constraints = new SearchControls();
        constraints.setSearchScope(2);
        String filter = this.ldapAttrMapping_.membershipTypeNameAttr + "=" + name;
        NamingEnumeration<SearchResult> results = ctx.search(this.ldapAttrMapping_.groupsURL, filter, constraints);
        while (results.hasMore()) {
            SearchResult sr = results.next();
            ctx.destroySubcontext(sr.getNameInNamespace());
        }
    }

    public MembershipType findMembershipType(String name) throws Exception {
        MembershipType membershipType = null;
        LdapContext ctx = this.ldapService_.getLdapContext();
        String membershipTypeDN = this.ldapAttrMapping_.membershipTypeNameAttr + "=" + name + "," + this.ldapAttrMapping_.membershipTypeURL;
        try {
            Attributes attrs = ctx.getAttributes(membershipTypeDN);
            if (attrs == null) {
                return membershipType;
            }
            membershipType = this.ldapAttrMapping_.attributesToMembershipType(attrs);
        }
        catch (NameNotFoundException e) {
            // empty catch block
        }
        return membershipType;
    }

    public Collection findMembershipTypes() throws Exception {
        LdapContext ctx = this.ldapService_.getLdapContext();
        ArrayList<MembershipType> memberships = new ArrayList<MembershipType>();
        String filter = this.ldapAttrMapping_.membershipTypeNameAttr + "=*";
        SearchControls constraints = new SearchControls();
        constraints.setSearchScope(2);
        NamingEnumeration<SearchResult> results = ctx.search(this.ldapAttrMapping_.membershipTypeURL, filter, constraints);
        while (results.hasMore()) {
            SearchResult sr = results.next();
            Attributes attrs = sr.getAttributes();
            memberships.add(this.ldapAttrMapping_.attributesToMembershipType(attrs));
        }
        return memberships;
    }
}

