/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.organization.ldap;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import javax.naming.directory.BasicAttributes;
import javax.naming.ldap.LdapContext;
import org.exoplatform.container.component.BaseComponentPlugin;
import org.exoplatform.container.component.ComponentPlugin;
import org.exoplatform.services.ldap.ObjectClassAttribute;
import org.exoplatform.services.organization.OrganizationService;
import org.exoplatform.services.organization.OrganizationServiceInitializer;
import org.exoplatform.services.organization.ldap.BaseDAO;

public class OrganizationLdapInitializer
extends BaseComponentPlugin
implements OrganizationServiceInitializer,
ComponentPlugin {
    private BaseDAO baseHandler;

    public void init(OrganizationService service) throws Exception {
        this.baseHandler = (BaseDAO)service.getUserHandler();
        this.createSubContext(this.baseHandler.ldapAttrMapping_.groupsURL);
        this.createSubContext(this.baseHandler.ldapAttrMapping_.userURL);
        this.createSubContext(this.baseHandler.ldapAttrMapping_.membershipTypeURL);
        this.createSubContext(this.baseHandler.ldapAttrMapping_.profileURL);
    }

    public void createSubContext(String dn) throws Exception {
        int i;
        Pattern pattern = Pattern.compile("\\b\\p{Space}*=\\p{Space}*", 2);
        Matcher matcher = pattern.matcher(dn);
        dn = matcher.replaceAll("=");
        LdapContext context = this.baseHandler.ldapService_.getLdapContext();
        String[] explodeDN = this.baseHandler.explodeDN(dn, false);
        if (explodeDN.length < 1) {
            return;
        }
        dn = explodeDN[explodeDN.length - 1];
        for (i = explodeDN.length - 2; i > -1 && explodeDN[i].startsWith("dc="); --i) {
            dn = explodeDN[i] + "," + dn;
        }
        this.createDN(dn, context);
        while (i > -1) {
            dn = explodeDN[i] + "," + dn;
            this.createDN(dn, context);
            --i;
        }
    }

    private void createDN(String dn, LdapContext context) throws Exception {
        try {
            Object obj = context.lookupLink(dn);
            if (obj != null) {
                return;
            }
        }
        catch (Exception exp) {
            // empty catch block
        }
        String nameValue = dn.substring(dn.indexOf("=") + 1, dn.indexOf(","));
        BasicAttributes attrs = new BasicAttributes();
        if (dn.toLowerCase().startsWith("ou=")) {
            attrs.put((Attribute)new ObjectClassAttribute(new String[]{"top", "organizationalUnit"}));
            attrs.put("ou", nameValue);
        } else if (dn.toLowerCase().startsWith("cn=")) {
            attrs.put((Attribute)new ObjectClassAttribute(new String[]{"top", "organizationalRole"}));
            attrs.put("cn", nameValue);
        } else if (dn.toLowerCase().startsWith("c=")) {
            attrs.put((Attribute)new ObjectClassAttribute(new String[]{"country"}));
            attrs.put("c", nameValue);
        } else if (dn.toLowerCase().startsWith("o=")) {
            attrs.put((Attribute)new ObjectClassAttribute(new String[]{"organization"}));
            attrs.put("o", nameValue);
        } else if (dn.toLowerCase().startsWith("dc=")) {
            attrs.put((Attribute)new ObjectClassAttribute(new String[]{"top", "dcObject", "organization"}));
            attrs.put("dc", nameValue);
            attrs.put("o", nameValue);
        }
        attrs.put("description", nameValue);
        context.createSubcontext(dn, (Attributes)attrs);
    }
}

