/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.organization.ldap;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.TreeMap;
import javax.naming.NameNotFoundException;
import javax.naming.NamingEnumeration;
import javax.naming.directory.Attributes;
import javax.naming.directory.BasicAttribute;
import javax.naming.directory.ModificationItem;
import javax.naming.directory.SearchControls;
import javax.naming.directory.SearchResult;
import javax.naming.ldap.LdapContext;
import org.exoplatform.commons.utils.ObjectPageList;
import org.exoplatform.commons.utils.PageList;
import org.exoplatform.services.ldap.LDAPService;
import org.exoplatform.services.organization.Query;
import org.exoplatform.services.organization.User;
import org.exoplatform.services.organization.UserEventListener;
import org.exoplatform.services.organization.UserHandler;
import org.exoplatform.services.organization.impl.UserImpl;
import org.exoplatform.services.organization.ldap.BaseDAO;
import org.exoplatform.services.organization.ldap.LDAPAttributeMapping;
import org.exoplatform.services.organization.ldap.LDAPUserPageList;

public class UserDAOImpl
extends BaseDAO
implements UserHandler {
    private List<UserEventListener> listeners_ = new ArrayList<UserEventListener>(5);

    public UserDAOImpl(LDAPAttributeMapping ldapAttrMapping, LDAPService ldapService) {
        super(ldapAttrMapping, ldapService);
    }

    public void addUserEventListener(UserEventListener listener) {
        this.listeners_.add(listener);
    }

    public User createUserInstance() {
        return new UserImpl();
    }

    public User createUserInstance(String username) {
        return new UserImpl(username);
    }

    public void createUser(User user, boolean broadcast) throws Exception {
        String userDN = this.ldapAttrMapping_.userDNKey + "=" + user.getUserName() + "," + this.ldapAttrMapping_.userURL;
        Attributes attrs = this.ldapAttrMapping_.userToAttributes(user);
        if (broadcast) {
            this.preSave(user, true);
        }
        this.ldapService_.getLdapContext().createSubcontext(userDN, attrs);
        if (broadcast) {
            this.postSave(user, true);
        }
    }

    public void saveUser(User user, boolean broadcast) throws Exception {
        ModificationItem mod;
        String userDN = this.getDNFromUsername(user.getUserName());
        if (userDN == null) {
            return;
        }
        User existingUser = this.getUserFromUsername(user.getUserName());
        ArrayList<ModificationItem> modifications = new ArrayList<ModificationItem>();
        if (!user.getFullName().equals(existingUser.getFullName())) {
            mod = new ModificationItem(2, new BasicAttribute(this.ldapAttrMapping_.userDisplayNameAttr, user.getFullName()));
            modifications.add(mod);
            mod = new ModificationItem(2, new BasicAttribute(this.ldapAttrMapping_.ldapDescriptionAttr, user.getFullName()));
            modifications.add(mod);
        }
        if (!user.getUserName().equals(existingUser.getUserName())) {
            mod = new ModificationItem(2, new BasicAttribute(this.ldapAttrMapping_.userUsernameAttr, user.getUserName()));
            modifications.add(mod);
        }
        if (!user.getLastName().equals(existingUser.getLastName())) {
            mod = new ModificationItem(2, new BasicAttribute(this.ldapAttrMapping_.userLastNameAttr, user.getLastName()));
            modifications.add(mod);
        }
        if (!user.getFirstName().equals(existingUser.getFirstName())) {
            mod = new ModificationItem(2, new BasicAttribute(this.ldapAttrMapping_.userFirstNameAttr, user.getFirstName()));
            modifications.add(mod);
        }
        if (!user.getEmail().equals(existingUser.getEmail())) {
            mod = new ModificationItem(2, new BasicAttribute(this.ldapAttrMapping_.userMailAttr, user.getEmail()));
            modifications.add(mod);
        }
        ModificationItem[] mods = new ModificationItem[modifications.size()];
        modifications.toArray(mods);
        if (broadcast) {
            this.preSave(user, false);
        }
        this.ldapService_.getLdapContext().modifyAttributes(userDN, mods);
        if (broadcast) {
            this.postSave(user, false);
        }
        if (!user.getPassword().equals("PASSWORD")) {
            this.saveUserPassword(user, userDN);
        }
    }

    void saveUserPassword(User user, String userDN) throws Exception {
        ModificationItem[] mods = new ModificationItem[]{new ModificationItem(2, new BasicAttribute(this.ldapAttrMapping_.userPassword, user.getPassword()))};
        this.ldapService_.getLdapContext().modifyAttributes(userDN, mods);
    }

    public User removeUser(String userName, boolean broadcast) throws Exception {
        User user = this.getUserFromUsername(userName);
        if (user == null) {
            return null;
        }
        LdapContext ctx = this.ldapService_.getLdapContext();
        if (broadcast) {
            this.preDelete(user);
        }
        ctx.destroySubcontext(this.getDNFromUsername(userName));
        if (broadcast) {
            this.postDelete(user);
        }
        return user;
    }

    public User findUserByName(String userName) throws Exception {
        return this.getUserFromUsername(userName);
    }

    public PageList findUsersByGroup(String groupId) throws Exception {
        ArrayList users = new ArrayList();
        TreeMap<String, User> map = new TreeMap<String, User>();
        LdapContext ctx = this.ldapService_.getLdapContext();
        String searchBase = this.getGroupDNFromGroupId(groupId);
        String filter = this.ldapAttrMapping_.membershipObjectClassFilter;
        SearchControls constraints = new SearchControls();
        constraints.setSearchScope(1);
        NamingEnumeration<SearchResult> results = ctx.search(searchBase, filter, constraints);
        while (results.hasMore()) {
            SearchResult sr = results.next();
            Attributes attrs = sr.getAttributes();
            List<Object> members = this.getAttributes(attrs, this.ldapAttrMapping_.membershipTypeMemberValue);
            for (int x = 0; x < members.size(); ++x) {
                User user = this.findUserByDN((String)members.get(x), ctx);
                if (user == null) continue;
                map.put(user.getUserName(), user);
            }
        }
        Iterator i = map.keySet().iterator();
        while (i.hasNext()) {
            users.add(map.get(i.next()));
        }
        return new ObjectPageList(users, 20);
    }

    protected User findUserByDN(String userDN, LdapContext ctx) throws Exception {
        if (userDN == null) {
            return null;
        }
        try {
            Attributes attrs = ctx.getAttributes(userDN);
            if (attrs == null) {
                return null;
            }
            User user = this.ldapAttrMapping_.attributesToUser(attrs);
            user.setFullName(user.getFirstName() + " " + user.getLastName());
            return user;
        }
        catch (NameNotFoundException e) {
            return null;
        }
    }

    public PageList getUserPageList(int pageSize) throws Exception {
        String searchBase = this.ldapAttrMapping_.userURL;
        String filter = this.ldapAttrMapping_.userObjectClassFilter;
        return new LDAPUserPageList(this.ldapAttrMapping_, this.ldapService_, searchBase, filter, pageSize);
    }

    public PageList findUsers(Query q) throws Exception {
        String filter = null;
        ArrayList<String> list = new ArrayList<String>();
        if (q.getUserName() != null && q.getUserName().length() > 0) {
            list.add("(" + this.ldapAttrMapping_.userUsernameAttr + "=" + q.getUserName() + ")");
        }
        if (q.getFirstName() != null && q.getFirstName().length() > 0) {
            list.add("(" + this.ldapAttrMapping_.userFirstNameAttr + "=" + q.getFirstName() + ")");
        }
        if (q.getLastName() != null && q.getLastName().length() > 0) {
            list.add("(" + this.ldapAttrMapping_.userLastNameAttr + "=" + q.getLastName() + ")");
        }
        if (q.getEmail() != null && q.getEmail().length() > 0) {
            list.add("(" + this.ldapAttrMapping_.userMailAttr + "=" + q.getEmail() + ")");
        }
        if (list.size() > 0) {
            StringBuilder buffer = new StringBuilder();
            buffer.append("(&");
            if (list.size() > 1) {
                for (int x = 0; x < list.size(); ++x) {
                    if (x == list.size() - 1) {
                        buffer.append((String)list.get(x));
                        continue;
                    }
                    buffer.append((String)list.get(x) + " || ");
                }
            } else {
                buffer.append((String)list.get(0));
            }
            buffer.append("(" + this.ldapAttrMapping_.userObjectClassFilter + ") )");
            filter = buffer.toString();
        } else {
            filter = this.ldapAttrMapping_.userObjectClassFilter;
        }
        String searchBase = this.ldapAttrMapping_.userURL;
        return new LDAPUserPageList(this.ldapAttrMapping_, this.ldapService_, searchBase, filter, 20);
    }

    public boolean authenticate(String username, String password) throws Exception {
        String userDN = this.getDNFromUsername(username);
        if (userDN == null) {
            return false;
        }
        try {
            return this.ldapService_.authenticate(userDN, password);
        }
        catch (Exception exp) {
            return false;
        }
    }

    protected void preSave(User user, boolean isNew) throws Exception {
        for (UserEventListener listener : this.listeners_) {
            listener.preSave(user, isNew);
        }
    }

    protected void postSave(User user, boolean isNew) throws Exception {
        for (UserEventListener listener : this.listeners_) {
            listener.postSave(user, isNew);
        }
    }

    protected void preDelete(User user) throws Exception {
        for (UserEventListener listener : this.listeners_) {
            listener.preDelete(user);
        }
    }

    protected void postDelete(User user) throws Exception {
        for (UserEventListener listener : this.listeners_) {
            listener.postDelete(user);
        }
    }
}

