/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.organization.ldap;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.naming.NameNotFoundException;
import javax.naming.directory.Attributes;
import javax.naming.directory.BasicAttribute;
import javax.naming.directory.InvalidAttributeValueException;
import javax.naming.directory.ModificationItem;
import javax.naming.ldap.LdapContext;
import org.exoplatform.services.ldap.LDAPService;
import org.exoplatform.services.organization.UserProfile;
import org.exoplatform.services.organization.UserProfileEventListener;
import org.exoplatform.services.organization.UserProfileHandler;
import org.exoplatform.services.organization.impl.UserProfileData;
import org.exoplatform.services.organization.impl.UserProfileImpl;
import org.exoplatform.services.organization.ldap.BaseDAO;
import org.exoplatform.services.organization.ldap.LDAPAttributeMapping;

public class UserProfileDAOImpl
extends BaseDAO
implements UserProfileHandler {
    private List<UserProfileEventListener> listeners_ = new ArrayList<UserProfileEventListener>(3);

    public UserProfileDAOImpl(LDAPAttributeMapping ldapAttrMapping, LDAPService ldapService) {
        super(ldapAttrMapping, ldapService);
    }

    public final UserProfile createUserProfileInstance() {
        return new UserProfileImpl();
    }

    public void createUser(UserProfile profile, boolean broadcast) throws Exception {
        LdapContext ctx = this.ldapService_.getLdapContext();
        String profileDN = this.ldapAttrMapping_.membershipTypeNameAttr + "=" + profile.getUserName() + "," + this.ldapAttrMapping_.profileURL;
        ctx.createSubcontext(profileDN, this.ldapAttrMapping_.profileToAttributes(profile));
    }

    public void saveUserProfile(UserProfile profile, boolean broadcast) throws Exception {
        LdapContext ctx = this.ldapService_.getLdapContext();
        String profileDN = this.ldapAttrMapping_.membershipTypeNameAttr + "=" + profile.getUserName() + "," + this.ldapAttrMapping_.profileURL;
        try {
            Attributes attrs = ctx.getAttributes(profileDN);
            if (attrs == null) {
                this.createUser(profile, broadcast);
                return;
            }
            UserProfileData upd = new UserProfileData();
            upd.setUserProfile(profile);
            ModificationItem[] mods = new ModificationItem[]{new ModificationItem(2, new BasicAttribute(this.ldapAttrMapping_.ldapDescriptionAttr, upd.getProfile()))};
            ctx.modifyAttributes(profileDN, mods);
        }
        catch (NameNotFoundException notfound) {
            this.createUser(profile, broadcast);
        }
        catch (InvalidAttributeValueException invalid) {
            invalid.printStackTrace();
        }
    }

    public UserProfile removeUserProfile(String userName, boolean broadcast) throws Exception {
        LdapContext ctx = this.ldapService_.getLdapContext();
        String profileDN = this.ldapAttrMapping_.membershipTypeNameAttr + "=" + userName + "," + this.ldapAttrMapping_.profileURL;
        try {
            Attributes attrs = ctx.getAttributes(profileDN);
            if (attrs == null) {
                return null;
            }
            UserProfile profile = this.ldapAttrMapping_.attributesToProfile(attrs).getUserProfile();
            ctx.destroySubcontext(profileDN);
            return profile;
        }
        catch (Exception exo) {
            return null;
        }
    }

    public UserProfile findUserProfileByName(String userName) throws Exception {
        LdapContext ctx = this.ldapService_.getLdapContext();
        String profileDN = this.ldapAttrMapping_.membershipTypeNameAttr + "=" + userName + "," + this.ldapAttrMapping_.profileURL;
        try {
            Attributes attrs = ctx.getAttributes(profileDN);
            if (attrs == null) {
                return null;
            }
            return this.ldapAttrMapping_.attributesToProfile(attrs).getUserProfile();
        }
        catch (Exception exo) {
            return null;
        }
    }

    public Collection findUserProfiles() throws Exception {
        return null;
    }

    public void addUserProfileEventListener(UserProfileEventListener listener) {
        this.listeners_.add(listener);
    }
}

