/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.config.impl;

import com.thoughtworks.xstream.XStream;
import com.thoughtworks.xstream.io.HierarchicalStreamDriver;
import com.thoughtworks.xstream.io.xml.XppDriver;
import java.io.Serializable;
import org.exoplatform.container.configuration.ConfigurationManager;
import org.exoplatform.services.config.ConfigurationService;
import org.exoplatform.services.config.impl.ConfigurationDataImpl;
import org.exoplatform.services.database.HibernateService;

public class ConfigurationServiceImpl
implements ConfigurationService {
    private ConfigurationManager manager_;
    private HibernateService hservice_;
    private XStream xstream_;

    public ConfigurationServiceImpl(ConfigurationManager manager, HibernateService service) {
        this.manager_ = manager;
        this.hservice_ = service;
        this.xstream_ = new XStream((HierarchicalStreamDriver)new XppDriver());
    }

    public Object getServiceConfiguration(Class serviceType) throws Exception {
        ConfigurationDataImpl impl = (ConfigurationDataImpl)this.hservice_.findOne(ConfigurationDataImpl.class, (Serializable)((Object)serviceType.getName()));
        Object obj = null;
        if (impl == null) {
            obj = this.loadDefaultConfig(serviceType);
            this.saveServiceConfiguration(serviceType, obj);
        } else {
            obj = this.xstream_.fromXML(impl.getData());
        }
        return obj;
    }

    public void saveServiceConfiguration(Class serviceType, Object config) throws Exception {
        ConfigurationDataImpl impl = (ConfigurationDataImpl)this.hservice_.findOne(ConfigurationDataImpl.class, (Serializable)((Object)serviceType.getName()));
        String xml = this.xstream_.toXML(config);
        if (impl == null) {
            impl = new ConfigurationDataImpl();
            impl.setServiceType(serviceType.getName());
            impl.setData(xml);
            this.hservice_.create((Object)impl);
        } else {
            impl.setData(xml);
            this.hservice_.update((Object)impl);
        }
    }

    public void removeServiceConfiguration(Class serviceType) throws Exception {
        this.hservice_.remove(serviceType, (Serializable)((Object)serviceType.getName()));
    }

    private Object loadDefaultConfig(Class serviceType) throws Exception {
        return null;
    }
}

