/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.resources.impl;

import java.io.InputStream;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.exoplatform.container.configuration.ConfigurationManager;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.services.resources.LocaleConfig;
import org.exoplatform.services.resources.LocaleConfigService;
import org.exoplatform.services.resources.impl.LocaleConfigImpl;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class LocaleConfigServiceImpl
implements LocaleConfigService {
    private LocaleConfig defaultConfig_;
    private Map configs_ = new HashMap(10);

    public LocaleConfigServiceImpl(InitParams params, ConfigurationManager cmanager) throws Exception {
        String confResource = params.getValueParam("locale.config.file").getValue();
        InputStream is = cmanager.getInputStream(confResource);
        this.parseConfiguration(is);
    }

    public LocaleConfig getDefaultLocaleConfig() {
        return this.defaultConfig_;
    }

    public LocaleConfig getLocaleConfig(String lang) {
        LocaleConfig config = (LocaleConfig)this.configs_.get(lang);
        if (config != null) {
            return config;
        }
        return this.defaultConfig_;
    }

    public Collection getLocalConfigs() {
        return this.configs_.values();
    }

    private void parseConfiguration(InputStream is) throws Exception {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        factory.setIgnoringComments(true);
        factory.setCoalescing(true);
        factory.setNamespaceAware(false);
        factory.setValidating(false);
        DocumentBuilder parser = factory.newDocumentBuilder();
        Document document = parser.parse(is);
        NodeList nodes = document.getElementsByTagName("locale-config");
        for (int i = 0; i < nodes.getLength(); ++i) {
            Node node = nodes.item(i);
            NodeList children = node.getChildNodes();
            LocaleConfigImpl config = new LocaleConfigImpl();
            for (int j = 0; j < children.getLength(); ++j) {
                Node element = children.item(j);
                if ("locale".equals(element.getNodeName())) {
                    config.setLocale(element.getFirstChild().getNodeValue());
                    continue;
                }
                if ("output-encoding".equals(element.getNodeName())) {
                    config.setOutputEncoding(element.getFirstChild().getNodeValue());
                    continue;
                }
                if ("input-encoding".equals(element.getNodeName())) {
                    config.setInputEncoding(element.getFirstChild().getNodeValue());
                    continue;
                }
                if (!"description".equals(element.getNodeName())) continue;
                config.setDescription(element.getFirstChild().getNodeValue());
            }
            this.configs_.put(config.getLanguage(), config);
            if (i != 0) continue;
            this.defaultConfig_ = config;
        }
    }
}

