/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.resources.impl;

import java.io.InputStream;
import java.io.Serializable;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.ResourceBundle;
import org.apache.commons.logging.Log;
import org.exoplatform.commons.utils.IOUtil;
import org.exoplatform.commons.utils.MapResourceBundle;
import org.exoplatform.commons.utils.PageList;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.services.cache.CacheService;
import org.exoplatform.services.cache.ExoCache;
import org.exoplatform.services.database.DBObjectPageList;
import org.exoplatform.services.database.HibernateService;
import org.exoplatform.services.database.ObjectQuery;
import org.exoplatform.services.log.LogService;
import org.exoplatform.services.resources.LocaleConfig;
import org.exoplatform.services.resources.LocaleConfigService;
import org.exoplatform.services.resources.Query;
import org.exoplatform.services.resources.ResourceBundleData;
import org.exoplatform.services.resources.ResourceBundleService;
import org.exoplatform.services.resources.impl.ExoResourceBundle;
import org.exoplatform.services.resources.impl.ResourceBundleDataImpl;
import org.exoplatform.services.resources.impl.ResourceBundleDescriptionImpl;
import org.hibernate.Session;

public class ResourceBundleServiceImpl
implements ResourceBundleService {
    private HibernateService hService_;
    private Log log_;
    private ExoCache cache_;
    private List classpathResources_;
    private LocaleConfigService localeService_;
    private String[] portalResourceBundleNames_;

    public ResourceBundleServiceImpl(HibernateService service, LocaleConfigService localeService, LogService lservice, CacheService cService, InitParams params) throws Exception {
        this.log_ = lservice.getLog("org.exoplatform.services.resources");
        this.cache_ = cService.getCacheInstance(this.getClass().getName());
        this.localeService_ = localeService;
        this.hService_ = service;
        this.classpathResources_ = params.getValuesParam("classpath.resources").getValues();
        ArrayList prnames = params.getValuesParam("portal.resource.names").getValues();
        this.portalResourceBundleNames_ = new String[prnames.size()];
        for (int i = 0; i < prnames.size(); ++i) {
            this.portalResourceBundleNames_[i] = (String)prnames.get(i);
        }
        PageList pl = this.findResourceDescriptions(new Query(null, null));
        if (pl.getAvailable() == 0) {
            ArrayList initResources = params.getValuesParam("init.resources").getValues();
            for (String resource : initResources) {
                this.initResources(resource, Thread.currentThread().getContextClassLoader());
            }
        }
    }

    public String[] getSharedResourceBundleNames() {
        return this.portalResourceBundleNames_;
    }

    public ResourceBundle getResourceBundle(String name, Locale locale) {
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        return this.getResourceBundle(name, locale, cl);
    }

    public ResourceBundle getResourceBundle(String name, Locale locale, ClassLoader cl) {
        if (this.isClasspathResource(name)) {
            return ResourceBundle.getBundle(name, locale, cl);
        }
        String id = name + "_" + locale.getLanguage();
        try {
            Object obj = this.cache_.get((Serializable)((Object)id));
            if (obj != null) {
                return (ResourceBundle)obj;
            }
        }
        catch (Exception ex) {
            // empty catch block
        }
        try {
            ResourceBundle res = null;
            String rootId = name + "_" + this.localeService_.getDefaultLocaleConfig().getLanguage();
            ResourceBundle parent = this.getResourceBundleFromDb(rootId, null, locale);
            if (parent != null) {
                res = this.getResourceBundleFromDb(id, parent, locale);
                if (res == null) {
                    res = parent;
                }
                this.cache_.put((Serializable)((Object)id), (Object)res);
                return res;
            }
        }
        catch (Exception ex) {
            this.log_.error((Object)("Error: " + id), (Throwable)ex);
        }
        return null;
    }

    public ResourceBundle getResourceBundle(String[] name, Locale locale) {
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        return this.getResourceBundle(name, locale, cl);
    }

    public ResourceBundle getResourceBundle(String[] name, Locale locale, ClassLoader cl) {
        StringBuilder idBuf = new StringBuilder("merge:");
        for (String n : name) {
            idBuf.append(n).append("_");
        }
        idBuf.append(locale.getLanguage());
        String id = idBuf.toString();
        try {
            ResourceBundle res = (ResourceBundle)this.cache_.get((Serializable)((Object)id));
            if (res != null) {
                return res;
            }
            MapResourceBundle outputBundled = new MapResourceBundle(locale);
            for (int i = 0; i < name.length; ++i) {
                ResourceBundle temp = this.getResourceBundle(name[i], locale, cl);
                if (temp != null) {
                    outputBundled.merge(temp);
                    continue;
                }
                this.log_.warn((Object)("Cannot load and merge the bundle: " + name[i]));
            }
            outputBundled.resolveDependencies();
            this.cache_.put((Serializable)((Object)id), (Object)outputBundled);
            return outputBundled;
        }
        catch (Exception ex) {
            this.log_.error((Object)("Cannot load and merge the bundle: " + id), (Throwable)ex);
            return null;
        }
    }

    public ResourceBundleData getResourceBundleData(String name) throws Exception {
        return (ResourceBundleDataImpl)this.hService_.findOne(ResourceBundleDataImpl.class, (Serializable)((Object)name));
    }

    public ResourceBundleData removeResourceBundleData(String id) throws Exception {
        ResourceBundleDataImpl data = (ResourceBundleDataImpl)this.hService_.remove(ResourceBundleDataImpl.class, (Serializable)((Object)id));
        this.cache_.remove((Serializable)((Object)data.getId()));
        return data;
    }

    public PageList findResourceDescriptions(Query q) throws Exception {
        String name = q.getName();
        if (name == null || name.length() == 0) {
            name = "%";
        }
        ObjectQuery oq = new ObjectQuery(ResourceBundleDescriptionImpl.class);
        oq.addLIKE("name", name);
        oq.addLIKE("language", q.getLanguage());
        oq.setDescOrderBy("name");
        return new DBObjectPageList(this.hService_, oq);
    }

    public void saveResourceBundle(ResourceBundleData data) throws Exception {
        this.hService_.save((Object)data);
        this.cache_.remove((Serializable)((Object)data.getId()));
    }

    private ResourceBundle getResourceBundleFromDb(String id, ResourceBundle parent, Locale locale) throws Exception {
        Session session = this.hService_.openSession();
        ResourceBundleDataImpl data = (ResourceBundleDataImpl)session.get(ResourceBundleDataImpl.class, (Serializable)((Object)id));
        if (data != null) {
            ExoResourceBundle res = new ExoResourceBundle(data.getData(), parent);
            MapResourceBundle mres = new MapResourceBundle((ResourceBundle)res, locale);
            return mres;
        }
        return null;
    }

    private void initResources(String baseName, ClassLoader cl) {
        String name = baseName.replace('.', '/');
        String fileName = null;
        try {
            Collection localeConfigs = this.localeService_.getLocalConfigs();
            String defaultLang = this.localeService_.getDefaultLocaleConfig().getLanguage();
            for (LocaleConfig localeConfig : localeConfigs) {
                String language = localeConfig.getLanguage();
                fileName = defaultLang.equals(language) ? name + ".properties" : name + "_" + language + ".properties";
                URL url = cl.getResource(fileName);
                if (url == null) continue;
                InputStream is = url.openStream();
                byte[] buf = IOUtil.getStreamContentAsBytes((InputStream)is);
                ResourceBundleDataImpl data = new ResourceBundleDataImpl();
                data.setId(baseName + "_" + language);
                data.setName(baseName);
                data.setLanguage(language);
                data.setData(new String(buf, "UTF-8"));
                this.saveResourceBundle(data);
                is.close();
            }
        }
        catch (Exception ex) {
            this.log_.error((Object)("Error while reading the file: " + fileName), (Throwable)ex);
        }
    }

    public ResourceBundleData createResourceBundleDataInstance() {
        return new ResourceBundleDataImpl();
    }

    private boolean isClasspathResource(String name) {
        if (this.classpathResources_ == null) {
            return false;
        }
        for (int i = 0; i < this.classpathResources_.size(); ++i) {
            String pack = (String)this.classpathResources_.get(i);
            if (!name.startsWith(pack)) continue;
            return true;
        }
        return false;
    }
}

