/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.security.jaas;

import java.util.List;
import java.util.Map;
import javax.security.auth.Subject;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.login.LoginException;
import javax.security.auth.spi.LoginModule;
import org.apache.commons.logging.Log;
import org.exoplatform.container.ExoContainer;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.container.RootContainer;
import org.exoplatform.container.component.ComponentRequestLifecycle;
import org.exoplatform.services.security.SecurityService;

public class BasicLoginModule
implements LoginModule {
    private static final String DEFAULT_DOMAIN = "portal";
    private SecurityService securityService_;
    private boolean success_ = false;
    private String username_ = null;
    private Subject subject_;
    private String portalDomain_;
    private CallbackHandler callbackHandler_;
    private Map sharedState_;
    private Map options_;
    private Log log_;

    public void initialize(Subject subject, CallbackHandler callbackHandler, Map sharedState, Map options) {
        this.subject_ = subject;
        this.callbackHandler_ = callbackHandler;
        this.sharedState_ = sharedState;
        this.options_ = options;
    }

    public boolean login() throws LoginException {
        boolean bl;
        block23: {
            String password;
            PortalContainer authContainer;
            PortalContainer savedContainer;
            List components;
            Callback[] callbacks;
            block21: {
                boolean bl2;
                block22: {
                    block19: {
                        boolean bl3;
                        block20: {
                            if (this.callbackHandler_ == null) {
                                throw new LoginException("CallbackHandler null");
                            }
                            callbacks = new Callback[]{new NameCallback("Username: "), new PasswordCallback("Password: ", false)};
                            components = null;
                            savedContainer = null;
                            authContainer = null;
                            this.callbackHandler_.handle(callbacks);
                            this.username_ = ((NameCallback)callbacks[0]).getName();
                            String identifier = new String(((PasswordCallback)callbacks[1]).getPassword());
                            int split = identifier.lastIndexOf("@");
                            if (split == 0) {
                                password = null;
                                this.portalDomain_ = identifier.substring(split + 1);
                            } else if (split == -1) {
                                password = identifier;
                                this.portalDomain_ = (String)this.options_.get("domain");
                                if (this.portalDomain_ == null) {
                                    throw new LoginException("Cannot identify  the  portal container");
                                }
                            } else {
                                password = identifier.substring(0, split);
                                this.portalDomain_ = identifier.substring(split + 1);
                            }
                            savedContainer = PortalContainer.getInstance();
                            authContainer = RootContainer.getInstance().getPortalContainer(this.portalDomain_);
                            PortalContainer.setInstance((PortalContainer)authContainer);
                            components = authContainer.getComponentInstancesOfType(ComponentRequestLifecycle.class);
                            for (ComponentRequestLifecycle component : components) {
                                component.startRequest((ExoContainer)authContainer);
                            }
                            this.securityService_ = (SecurityService)authContainer.getComponentInstanceOfType(SecurityService.class);
                            this.log_ = this.securityService_.getLog();
                            if (this.username_ != null) break block19;
                            this.success_ = false;
                            bl3 = false;
                            if (authContainer == null) break block20;
                            for (ComponentRequestLifecycle component : components) {
                                component.endRequest((ExoContainer)authContainer);
                            }
                            PortalContainer.setInstance((PortalContainer)savedContainer);
                        }
                        return bl3;
                    }
                    if (password != null) break block21;
                    this.success_ = false;
                    bl2 = false;
                    if (authContainer == null) break block22;
                    for (ComponentRequestLifecycle component : components) {
                        component.endRequest((ExoContainer)authContainer);
                    }
                    PortalContainer.setInstance((PortalContainer)savedContainer);
                }
                return bl2;
            }
            try {
                this.sharedState_.put("javax.security.auth.login.name", this.username_);
                this.sharedState_.put("javax.security.auth.login.password", password);
                ((PasswordCallback)callbacks[1]).clearPassword();
                this.success_ = this.securityService_.authenticate(this.username_, password);
                if (!this.success_) {
                    this.log_.debug((Object)"Authentication failed");
                    throw new LoginException("Authentication failed");
                }
                this.subject_.getPrivateCredentials().add(password);
                bl = true;
                if (authContainer == null) break block23;
            }
            catch (Exception e) {
                try {
                    e.printStackTrace();
                    this.log_.error((Object)"error while trying to login", (Throwable)e);
                    throw new LoginException("Authentication failed");
                }
                catch (Throwable throwable) {
                    if (authContainer != null) {
                        for (ComponentRequestLifecycle component : components) {
                            component.endRequest(authContainer);
                        }
                        PortalContainer.setInstance(savedContainer);
                    }
                    throw throwable;
                }
            }
            for (ComponentRequestLifecycle component : components) {
                component.endRequest((ExoContainer)authContainer);
            }
            PortalContainer.setInstance((PortalContainer)savedContainer);
        }
        return bl;
    }

    public boolean commit() throws LoginException {
        if (this.success_) {
            List components = null;
            PortalContainer savedContainer = null;
            PortalContainer authContainer = null;
            try {
                savedContainer = PortalContainer.getInstance();
                authContainer = RootContainer.getInstance().getPortalContainer(this.portalDomain_);
                PortalContainer.setInstance((PortalContainer)authContainer);
                components = authContainer.getComponentInstancesOfType(ComponentRequestLifecycle.class);
                for (ComponentRequestLifecycle component : components) {
                    component.startRequest((ExoContainer)authContainer);
                }
                this.securityService_.setUpAndCacheSubject(this.username_, this.subject_);
            }
            catch (Exception e) {
                throw new LoginException("error while filling subject with Principal in commit() of BasicLoginModule");
            }
            finally {
                if (authContainer != null) {
                    for (ComponentRequestLifecycle component : components) {
                        component.startRequest((ExoContainer)authContainer);
                    }
                    PortalContainer.setInstance((PortalContainer)savedContainer);
                }
            }
        }
        return this.success_;
    }

    public boolean abort() throws LoginException {
        this.log_.debug((Object)"call abort()");
        this.clear();
        return this.success_;
    }

    public boolean logout() throws LoginException {
        this.log_.debug((Object)("logout user: " + this.username_));
        this.securityService_.removeSubject(this.username_);
        this.clear();
        return true;
    }

    private void clear() {
        this.subject_.getPrincipals().clear();
        this.subject_.getPrivateCredentials().clear();
        this.subject_.getPublicCredentials().clear();
        this.username_ = null;
    }
}

