/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.security.jaas;

import java.util.Map;
import javax.security.auth.Subject;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.login.LoginException;
import javax.security.auth.spi.LoginModule;
import org.apache.commons.logging.Log;
import org.exoplatform.container.StandaloneContainer;
import org.exoplatform.services.security.SecurityService;

public class StandaloneLoginModule
implements LoginModule {
    private SecurityService securityService_;
    private boolean success_ = false;
    private String username_ = null;
    private Subject subject_;
    private CallbackHandler callbackHandler_;
    private Map sharedState_;
    private Log log_;

    public void initialize(Subject subject, CallbackHandler callbackHandler, Map sharedState, Map options) {
        this.subject_ = subject;
        this.callbackHandler_ = callbackHandler;
        this.sharedState_ = sharedState;
    }

    public boolean login() throws LoginException {
        if (this.callbackHandler_ == null) {
            throw new LoginException("CallbackHandler null");
        }
        Callback[] callbacks = new Callback[]{new NameCallback("Username: "), new PasswordCallback("Password: ", false)};
        try {
            StandaloneContainer container = StandaloneContainer.getInstance();
            this.callbackHandler_.handle(callbacks);
            this.username_ = ((NameCallback)callbacks[0]).getName();
            String password = new String(((PasswordCallback)callbacks[1]).getPassword());
            if ("".equals(password)) {
                password = null;
            }
            this.securityService_ = (SecurityService)container.getComponentInstanceOfType(SecurityService.class);
            this.log_ = this.securityService_.getLog();
            if (this.username_ == null) {
                this.log_.debug((Object)"No user name entered");
                this.success_ = false;
                return false;
            }
            if (password == null) {
                this.log_.debug((Object)"No password entered");
                this.success_ = false;
                return false;
            }
            this.sharedState_.put("javax.security.auth.login.name", this.username_);
            this.sharedState_.put("javax.security.auth.login.password", password);
            ((PasswordCallback)callbacks[1]).clearPassword();
            this.success_ = this.securityService_.authenticate(this.username_, password);
            if (!this.success_) {
                this.log_.debug((Object)"Authentication failed");
                throw new LoginException("Authentication failed");
            }
            this.subject_.getPrivateCredentials().add(password);
            return true;
        }
        catch (Exception e) {
            this.log_.error((Object)"error while trying to login", (Throwable)e);
            throw new LoginException("Authentication failed");
        }
    }

    public boolean commit() throws LoginException {
        if (this.success_) {
            try {
                this.securityService_.setUpAndCacheSubject(this.username_, this.subject_);
            }
            catch (Exception e) {
                throw new LoginException("error while filling subject with Principal in commit() of BasicLoginModule");
            }
        }
        return this.success_;
    }

    public boolean abort() throws LoginException {
        this.log_.debug((Object)"call abort()");
        this.clear();
        return this.success_;
    }

    public boolean logout() throws LoginException {
        this.log_.debug((Object)("logout user: " + this.username_));
        this.securityService_.removeSubject(this.username_);
        this.clear();
        return true;
    }

    private void clear() {
        this.subject_.getPrincipals().clear();
        this.subject_.getPrivateCredentials().clear();
        this.subject_.getPublicCredentials().clear();
        this.username_ = null;
    }
}

