/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.ticket.impl;

import java.io.Serializable;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.exoplatform.commons.utils.ExoProperties;
import org.exoplatform.services.database.HibernateService;
import org.exoplatform.services.ticket.Ticket;
import org.exoplatform.services.ticket.TicketCommand;
import org.exoplatform.services.ticket.TicketService;
import org.exoplatform.services.ticket.impl.TicketImpl;

public class TicketServiceImpl
implements TicketService {
    private HibernateService hservice_;
    private Map<String, String> locks_ = new HashMap<String, String>();

    public TicketServiceImpl(HibernateService hservice) {
        this.hservice_ = hservice;
    }

    public String createTicket(long liveTime, int limit, String desc, TicketCommand command) throws Exception {
        return this.createTicket(liveTime, limit, desc, null, null, null, command);
    }

    public String createTicket(long liveTime, int limitAccess, String desc, String owenCreator, String[] allowedUser, String[] requiredPermissions, TicketCommand command) throws Exception {
        TicketImpl ticket = new TicketImpl();
        ticket.setId(Integer.toString(ticket.hashCode()));
        ticket.setCreationTime(new Date());
        ticket.setAccessCounter(0);
        ticket.setLimitAccess(limitAccess);
        ticket.setCreator(owenCreator);
        ticket.setLiveTime(liveTime);
        ticket.setDescription(desc);
        if (limitAccess == -1) {
            ticket.setStatus(-1);
        } else if (limitAccess < -1 || limitAccess == 0) {
            ticket.setStatus(2);
        } else {
            ticket.setStatus(0);
        }
        ticket.setAllowedUsers(allowedUser);
        ticket.setRequiredPermissions(requiredPermissions);
        ticket.setTicketCommandClass(command.getClass().getName());
        ticket.setProperties(command.getProperty(TicketCommand.PROPERTIES_NAME));
        this.hservice_.save((Object)ticket);
        return ticket.getId();
    }

    public Ticket getTicket(String id) throws Exception {
        TicketImpl impl = (TicketImpl)this.hservice_.findOne(TicketImpl.class, (Serializable)((Object)id));
        return impl;
    }

    public Ticket getTicket(String id, String accessUser) throws Exception {
        boolean checkAcessUser = false;
        if (accessUser == null) {
            return null;
        }
        TicketImpl impl = (TicketImpl)this.getTicket(id);
        if (impl == null) {
            return null;
        }
        String[] users = impl.getAlowUsers();
        for (int i = 0; i < users.length; ++i) {
            if (!users[i].equals(accessUser)) continue;
            checkAcessUser = true;
            break;
        }
        if (checkAcessUser) {
            return impl;
        }
        return null;
    }

    public Object executeTicketCommand(String ticketId) throws Exception {
        TicketImpl ticket = (TicketImpl)this.getTicket(ticketId);
        return this.executeTicketCommand(ticket, null);
    }

    public Object executeTicketCommand(Ticket ticket) throws Exception {
        return this.executeTicketCommand(ticket, null);
    }

    public Object executeTicketCommand(String ticketId, String accessUser) throws Exception {
        TicketImpl ticket = (TicketImpl)this.getTicket(ticketId, accessUser);
        return this.executeTicketCommand(ticket, accessUser);
    }

    public Object executeTicketCommand(Ticket ticket, String accessUser) throws Exception {
        TicketImpl ticketImpl = null;
        try {
            Object object;
            this.lock(ticket.getId());
            ticketImpl = (TicketImpl)ticket;
            this.lockService(ticket);
            String[] users = ticketImpl.getAlowUsers();
            boolean allow = false;
            int status = 0;
            int count = 0;
            if (users == null) {
                status = ticketImpl.getStatus();
                count = ticketImpl.getAccessCounter();
                if (status == 0 || status == -1) {
                    ticketImpl.setLastAccessUser(null);
                    ClassLoader cl = Thread.currentThread().getContextClassLoader();
                    Class<?> clazz = cl.loadClass(ticketImpl.getTicketCommandClass());
                    TicketCommand command = (TicketCommand)clazz.newInstance();
                    String properties = ticketImpl.getProperties();
                    if (properties != null && properties.length() > 0) {
                        ExoProperties props = new ExoProperties();
                        props.addPropertiesFromText(properties);
                        command.setProperties((Map)props);
                    }
                    ticketImpl.setTicketCommand(command);
                } else {
                    ticketImpl.setAccessCounter(count);
                    this.hservice_.save((Object)ticketImpl);
                    ticketImpl = null;
                }
                allow = true;
            } else {
                for (int i = 0; i < users.length; ++i) {
                    if (!users[i].equals(accessUser)) continue;
                    if (ticketImpl.getStatus() == 0) {
                        ticketImpl.setLastAccessUser(accessUser);
                        ClassLoader cl = Thread.currentThread().getContextClassLoader();
                        Class<?> clazz = cl.loadClass(ticketImpl.getTicketCommandClass());
                        TicketCommand command = (TicketCommand)clazz.newInstance();
                        String properties = ticketImpl.getProperties();
                        if (properties != null && properties.length() > 0) {
                            ExoProperties props = new ExoProperties();
                            props.addPropertiesFromText(properties);
                            command.setProperties((Map)props);
                        }
                        ticketImpl.setTicketCommand(command);
                    }
                    allow = true;
                    break;
                }
            }
            if (!allow) {
                ticketImpl.setAccessCounter(count - 1);
                this.hservice_.save((Object)ticketImpl);
                throw new Exception("The user '" + accessUser + "' do now have the permission to access the ticket");
            }
            if (ticketImpl == null) {
                String i = Integer.toString(status);
                return i;
            }
            TicketCommand command = ticketImpl.getTicketCommand();
            if (command == null) {
                object = Integer.toString(status);
                return object;
            }
            object = command.execute();
            return object;
        }
        catch (Exception e) {
            throw e;
        }
        finally {
            this.unlock(ticket.getId());
            if (ticketImpl != null && ticketImpl.getAccessCounter() == ticketImpl.getLimitAccess()) {
                ticketImpl.setStatus(2);
                this.hservice_.save((Object)ticketImpl);
            }
        }
    }

    private int increaseCount(TicketImpl ticketImpl) {
        int nowAccessCount = ticketImpl.getAccessCounter();
        if (ticketImpl.getLimitAccess() == -1) {
            return ++nowAccessCount;
        }
        if (nowAccessCount == ticketImpl.getLimitAccess()) {
            ticketImpl.setStatus(2);
            try {
                this.hservice_.save((Object)ticketImpl);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        if (nowAccessCount < ticketImpl.getLimitAccess()) {
            ++nowAccessCount;
        }
        return nowAccessCount;
    }

    private void lockService(Ticket ticket) {
        TicketImpl ticketImpl = (TicketImpl)ticket;
        int status = ticketImpl.getStatus();
        if (status == 0 || status == -1) {
            Long timeLock = ticketImpl.getLastAccessTime().getTime();
            if (new Date().getTime() > timeLock) {
                ticketImpl.setStatus(1);
            } else {
                int nowAccessCount = this.increaseCount(ticketImpl);
                ticketImpl.setAccessCounter(nowAccessCount);
            }
            try {
                this.hservice_.save((Object)ticketImpl);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    private synchronized void lock(String ticketId) throws Exception {
        if (this.locks_.get(ticketId) != null) {
            throw new Exception("Some one is using the  ticket");
        }
        this.locks_.put(ticketId, ticketId);
    }

    private synchronized void unlock(String ticketId) throws Exception {
        this.locks_.remove(ticketId);
    }

    public void removeTicket(String ticketId) throws Exception {
        Ticket ticket = this.getTicket(ticketId);
        this.hservice_.remove((Object)ticket);
    }
}

