/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.templates.velocity.impl;

import java.io.File;
import java.io.InputStream;
import java.lang.ref.SoftReference;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import org.apache.commons.collections.ExtendedProperties;
import org.apache.velocity.Template;
import org.apache.velocity.exception.ParseErrorException;
import org.apache.velocity.exception.ResourceNotFoundException;
import org.apache.velocity.runtime.resource.Resource;
import org.apache.velocity.runtime.resource.ResourceFactory;
import org.apache.velocity.runtime.resource.loader.ResourceLoader;
import org.apache.velocity.util.StringUtils;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.services.templates.velocity.ResourceLoaderPlugin;
import org.exoplatform.services.templates.velocity.StaticResourceLoader;

public class StaticResourceLoaderImpl
extends ResourceLoaderPlugin
implements StaticResourceLoader {
    private Map<String, String> templatesSearchPaths_ = new HashMap<String, String>();
    private Map templatePaths = new HashMap();
    private Map resourcesInfo_ = null;
    private boolean checkModified_;

    public StaticResourceLoaderImpl(InitParams params) throws Exception {
        ArrayList paths = params.getValuesParam("velocity.template.path").getValues();
        for (String path : paths) {
            this.templatesSearchPaths_.put(path, path);
        }
        this.checkModified_ = "true".equals(params.getValueParam("check.modified.resource").getValue());
        this.resourcesInfo_ = new Hashtable();
    }

    public void init(ExtendedProperties configuration) {
    }

    public synchronized InputStream getResourceStream(String templateName) throws ResourceNotFoundException {
        ResourceInfo rinfo = (ResourceInfo)this.resourcesInfo_.get(templateName);
        try {
            return rinfo.url.openStream();
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return null;
        }
    }

    public synchronized URL getURL(String templateName) throws ResourceNotFoundException {
        String template = StringUtils.normalizePath((String)templateName);
        if (template == null || template.length() == 0) {
            throw new ResourceNotFoundException("Template parameter cannot be null or empty");
        }
        if (template.startsWith("/")) {
            template = template.substring(1);
        }
        for (String path : this.templatesSearchPaths_.values()) {
            URL url = this.findURL(path, template);
            if (url == null) continue;
            return url;
        }
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        URL url = cl.getResource(templateName);
        if (url != null) {
            return url;
        }
        throw new ResourceNotFoundException("FileResourceLoader Error: cannot find resource " + template);
    }

    private URL findURL(String path, String template) {
        try {
            File file = new File(path, template);
            if (file.canRead()) {
                return file.toURL();
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return null;
    }

    public boolean isSourceModified(Resource resource) {
        boolean modified = true;
        String fileName = resource.getName();
        String path = (String)this.templatePaths.get(fileName);
        File currentFile = null;
        for (int i = 0; currentFile == null && i < this.templatesSearchPaths_.size(); ++i) {
            String testPath = this.templatesSearchPaths_.get(i);
            File testFile = new File(testPath, fileName);
            if (!testFile.canRead()) continue;
            currentFile = testFile;
        }
        File file = new File(path, fileName);
        if (currentFile != null && file.exists() && currentFile.equals(file) && file.canRead()) {
            modified = file.lastModified() != resource.getLastModified();
        }
        return modified;
    }

    public long getLastModified(Resource resource) {
        String path = (String)this.templatePaths.get(resource.getName());
        File file = new File(path, resource.getName());
        if (file.canRead()) {
            return file.lastModified();
        }
        return 0L;
    }

    public void addPath(String newPath) {
        this.templatesSearchPaths_.put(newPath, newPath);
    }

    public Template getTemplate(String name) throws Exception {
        Resource resource;
        ResourceInfo rinfo = (ResourceInfo)this.resourcesInfo_.get(name);
        if (rinfo != null && rinfo.ref != null && (resource = rinfo.ref.get()) != null) {
            if (this.checkModified_) {
                this.refreshResource(resource, rinfo.encoding);
            }
            return (Template)resource;
        }
        return null;
    }

    public Resource getResource(String resourceName, int resourceType, String encoding) throws ResourceNotFoundException, ParseErrorException, Exception {
        ResourceInfo rinfo = (ResourceInfo)this.resourcesInfo_.get(resourceName);
        if (rinfo == null) {
            URL url = this.getURL(resourceName);
            rinfo = new ResourceInfo(resourceName, encoding, url);
            this.resourcesInfo_.put(resourceName, rinfo);
        }
        Resource resource = null;
        if (rinfo.ref != null) {
            resource = rinfo.ref.get();
        }
        if (resource != null) {
            if (this.checkModified_) {
                this.refreshResource(resource, encoding);
            }
            return resource;
        }
        resource = ResourceFactory.getResource((String)resourceName, (int)resourceType);
        resource.setRuntimeServices(this.rsvc);
        resource.setName(resourceName);
        resource.setEncoding(encoding);
        resource.setResourceLoader((ResourceLoader)this);
        resource.process();
        if (resource.getData() == null) {
            throw new ResourceNotFoundException("Unable to find resource '" + resourceName + "'");
        }
        resource.setLastModified(0L);
        resource.setModificationCheckInterval(this.getModificationCheckInterval());
        resource.touch();
        rinfo.ref = new SoftReference<Resource>(resource);
        return resource;
    }

    protected void refreshResource(Resource resource, String encoding) throws ResourceNotFoundException, ParseErrorException, Exception {
        resource.touch();
        if (resource.isSourceModified()) {
            if (!resource.getEncoding().equals(encoding)) {
                this.rsvc.error((Object)("Declared encoding for template '" + resource.getName() + "' is different on reload.  Old = '" + resource.getEncoding() + "'  New = '" + encoding));
                resource.setEncoding(encoding);
            }
            long howOldItWas = resource.getResourceLoader().getLastModified(resource);
            resource.process();
            resource.setLastModified(howOldItWas);
        }
    }

    public boolean canLoadResource(String s) {
        return true;
    }

    public void addTemplate(String name, URL url) {
        this.resourcesInfo_.put(name, new ResourceInfo(name, "UTF-8", url));
    }

    public static class ResourceInfo {
        String name;
        String encoding;
        URL url;
        SoftReference<Resource> ref;

        public ResourceInfo(String name, String encoding, URL url) {
            this.name = name;
            this.url = url;
            this.encoding = encoding;
        }
    }
}

