/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.xml.querying.impl.xtas;

import java.util.ArrayList;
import org.exoplatform.services.xml.querying.InvalidStatementException;
import org.exoplatform.services.xml.querying.Statement;
import org.exoplatform.services.xml.querying.impl.xtas.ForbiddenOperationException;
import org.exoplatform.services.xml.querying.impl.xtas.Instruction;
import org.exoplatform.services.xml.querying.impl.xtas.InstructionsSupport;
import org.exoplatform.services.xml.querying.impl.xtas.QueryType;
import org.exoplatform.services.xml.querying.impl.xtas.ResourceInstruction;
import org.exoplatform.services.xml.querying.impl.xtas.UniFormTree;
import org.exoplatform.services.xml.querying.impl.xtas.XMLInstruction;

public abstract class BaseStatement
implements InstructionsSupport,
Statement {
    protected String destinationId;
    protected String sourceId;
    private ArrayList instructions = new ArrayList();

    public final String getSourceId() {
        return this.sourceId;
    }

    public final void setSourceId(String sourceId) {
        this.sourceId = sourceId;
    }

    public final String getDestinationId() {
        return this.destinationId;
    }

    public final void setDestinationId(String destinationId) {
        this.destinationId = destinationId;
    }

    public Instruction[] getInstructions() {
        Instruction[] ins = new Instruction[this.instructions.size()];
        for (int i = 0; i < this.instructions.size(); ++i) {
            ins[i] = (Instruction)this.instructions.get(i);
        }
        return ins;
    }

    public void addInstruction(String type, String match, UniFormTree newValue) throws InvalidStatementException {
        if (QueryType.isAtResource(type)) {
            this.instructions.add(new ResourceInstruction(type, match, newValue));
            this.destinationId = match;
        } else if (QueryType.isAtXml(type)) {
            this.instructions.add(new XMLInstruction(type, match, newValue));
        } else {
            throw new InvalidStatementException("Add Instruction Error: Invalid instruction type '" + type + "'!");
        }
    }

    public Instruction pickNextInstruction() throws ForbiddenOperationException, InvalidStatementException {
        if (this.instructions.size() == 0) {
            throw new ForbiddenOperationException("It is no more instructions!");
        }
        Instruction instr = (Instruction)this.instructions.get(0);
        this.instructions.remove(0);
        return instr;
    }

    public String toString() {
        String srcStr = "";
        String destStr = "";
        if (this.sourceId != null) {
            srcStr = " source=\"" + this.sourceId + "\"";
        }
        if (this.destinationId != null) {
            destStr = " destination=\"" + this.destinationId + "\"";
        }
        String instrString = "";
        for (int i = 0; i < this.instructions.size(); ++i) {
            instrString = instrString + this.instructions.get(i);
        }
        return "<query" + srcStr + destStr + ">" + instrString + "</query>";
    }
}

