/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.xml.querying.impl.xtas;

import java.io.ByteArrayInputStream;
import java.io.FileInputStream;
import java.io.InputStream;
import org.exoplatform.services.xml.querying.InvalidSourceException;
import org.exoplatform.services.xml.querying.InvalidStatementException;
import org.exoplatform.services.xml.querying.QueryRunTimeException;
import org.exoplatform.services.xml.querying.UniFormTransformationException;
import org.exoplatform.services.xml.querying.impl.xtas.InstructionCompiler;
import org.exoplatform.services.xml.querying.impl.xtas.QueryType;
import org.exoplatform.services.xml.querying.impl.xtas.UniFormTree;
import org.exoplatform.services.xml.querying.impl.xtas.UniFormTreeFragment;

public abstract class Instruction {
    private static final String XTAS_XSL = "/xtas.xsl";
    protected static InstructionCompiler compiler;
    protected String match;
    protected UniFormTree newValue;
    protected String type;

    protected Instruction(String type, String match, UniFormTree newValue) throws InvalidStatementException {
        if (type == null || type.trim() == "") {
            throw new InvalidStatementException("Query Type can not be NULL !");
        }
        this.type = type.toLowerCase();
        if (!QueryType.exists(this.type)) {
            throw new InvalidStatementException("Illegal query type '" + this.type + "' !");
        }
        if (match == null || match.trim() == "") {
            throw new InvalidStatementException("Match attribute is required for '" + type + "' statement");
        }
        this.match = match;
        try {
            if (newValue == null) {
                this.newValue = new UniFormTreeFragment();
                ((UniFormTreeFragment)this.newValue).init(new ByteArrayInputStream("".getBytes()));
            } else {
                this.newValue = newValue;
            }
        }
        catch (UniFormTransformationException e) {
            // empty catch block
        }
    }

    protected Instruction(Instruction instr) {
        this.type = instr.type;
        this.match = instr.match;
        this.newValue = instr.newValue;
    }

    public UniFormTree getNewValue() {
        return this.newValue;
    }

    public String getMatch() {
        return this.match;
    }

    public String getType() {
        return this.type;
    }

    public boolean isAtResource() {
        return QueryType.isAtResource(this.type);
    }

    public boolean isAtXml() {
        return QueryType.isAtXml(this.type);
    }

    public String toString() {
        return this.getAsString();
    }

    public abstract String getAsString();

    public abstract UniFormTree execute(UniFormTree var1) throws InvalidSourceException, QueryRunTimeException;

    public abstract void compile() throws InvalidStatementException;

    public abstract void setContext(Object var1);

    static {
        try {
            String xtasXsl = System.getProperty("xtas.xsl");
            InputStream is = null;
            is = xtasXsl == null || xtasXsl.equals("") ? Instruction.class.getResourceAsStream(XTAS_XSL) : new FileInputStream(xtasXsl);
            compiler = new InstructionCompiler(is);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

