/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.xml.querying.impl.xtas;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.exoplatform.services.xml.querying.InvalidStatementException;
import org.exoplatform.services.xml.querying.impl.xtas.Command;
import org.exoplatform.services.xml.querying.impl.xtas.InstructionCompilerException;

public class InstructionCompiler {
    protected Transformer queryResolver;

    public InstructionCompiler(InputStream xslStream) throws InstructionCompilerException {
        try {
            TransformerFactory tFactory = TransformerFactory.newInstance();
            this.queryResolver = tFactory.newTransformer(new StreamSource(xslStream));
        }
        catch (Exception e) {
            throw new InstructionCompilerException("Can not instantiate an InstructionCompiler Reason: " + e);
        }
    }

    public Command compile(String instruction) throws InvalidStatementException {
        try {
            ByteArrayOutputStream os = new ByteArrayOutputStream();
            StreamResult strRes = new StreamResult(os);
            this.queryResolver.transform(new StreamSource(new ByteArrayInputStream(instruction.getBytes())), strRes);
            return new Command(os.toByteArray());
        }
        catch (TransformerException e) {
            throw new InvalidStatementException("Can not init XSLTStatement Reason: " + e);
        }
    }
}

