/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.xml.querying.impl.xtas;

import java.io.IOException;
import java.io.InputStream;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.exoplatform.services.xml.querying.InvalidDestinationException;
import org.exoplatform.services.xml.querying.InvalidSourceException;
import org.exoplatform.services.xml.querying.InvalidStatementException;
import org.exoplatform.services.xml.querying.QueryRunTimeException;
import org.exoplatform.services.xml.querying.Statement;
import org.exoplatform.services.xml.querying.UniFormTransformationException;
import org.exoplatform.services.xml.querying.XMLData;
import org.exoplatform.services.xml.querying.XMLQuery;
import org.exoplatform.services.xml.querying.impl.xtas.BaseStatement;
import org.exoplatform.services.xml.querying.impl.xtas.ForbiddenOperationException;
import org.exoplatform.services.xml.querying.impl.xtas.Instruction;
import org.exoplatform.services.xml.querying.impl.xtas.UniFormConverter;
import org.exoplatform.services.xml.querying.impl.xtas.UniFormTree;
import org.exoplatform.services.xml.querying.impl.xtas.UniFormTreeFragment;
import org.exoplatform.services.xml.querying.impl.xtas.WellFormedUniFormTree;
import org.exoplatform.services.xml.querying.impl.xtas.resource.Resource;
import org.exoplatform.services.xml.querying.impl.xtas.resource.ResourceResolver;

public class Query
implements XMLQuery {
    private static Log _log = LogFactory.getLog(Query.class);
    private BaseStatement statement;
    private Object resourceContext;
    private UniFormTree input;
    private UniFormTree result = null;
    private boolean validate = false;
    private Instruction executedInstruction;

    public Query() {
    }

    public Query(Statement statement) throws InvalidSourceException {
        this.prepare(statement);
    }

    public Query(Statement statement, InputStream inputStream) throws InvalidSourceException {
        this(statement);
        this.setInputStream(inputStream);
    }

    public void execute() throws InvalidSourceException, QueryRunTimeException {
        if (this.statement == null) {
            throw new QueryRunTimeException("Query execution Error: XTAS Statement Can Not be NULL. Call prepare() first !");
        }
        Instruction curInstruction = null;
        int count = this.statement.getInstructions().length;
        if (count == 0) {
            throw new QueryRunTimeException("Query execution Error: XTAS Statement has not instructions to execute !");
        }
        if (count > 1) {
            throw new QueryRunTimeException("TEMPORARY Query execution Error: XTAS Statement does not support more than 1 instructions!");
        }
        for (int i = 0; i < count; ++i) {
            try {
                curInstruction = this.statement.pickNextInstruction();
                curInstruction.compile();
                curInstruction.setContext(this.resourceContext);
                this.result = curInstruction.execute(this.input);
            }
            catch (InvalidStatementException e) {
                throw new QueryRunTimeException(e.toString());
            }
            catch (ForbiddenOperationException e) {
                throw new QueryRunTimeException(e.toString());
            }
            this.executedInstruction = curInstruction;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void serialize() throws IOException, InvalidDestinationException {
        Resource destination;
        if (this.result == null) {
            return;
        }
        String destId = this.statement.getDestinationId();
        if (destId == null) throw new InvalidDestinationException("Query.serialize() Can not prepare query's destination. Destination ID is NULL ");
        try {
            destination = ResourceResolver.getInstance().getResource(destId);
        }
        catch (Exception e) {
            throw new InvalidDestinationException("Query.serialize() Can not prepare query's destination. Reason: " + e);
        }
        if (destination == null) throw new InvalidDestinationException("XTAS Destination not described!");
        try {
            destination.setContext(this.resourceContext);
            WellFormedUniFormTree _xml = UniFormConverter.toWellForm(this.result);
            _xml.setOmitXmlDeclaration(false);
            _xml.setIndentOutput(true);
            String sysId = null;
            String pubId = null;
            if (this.input != null) {
                WellFormedUniFormTree _inxml = UniFormConverter.toWellForm(this.input);
                sysId = _inxml.getValidationHandler().getSystemId();
                pubId = _inxml.getValidationHandler().getPublicId();
            }
            if (sysId != null) {
                _xml.setDTDSystemId(sysId);
            }
            if (pubId != null) {
                _xml.setDTDPublicId(pubId);
            }
            if (sysId != null || pubId != null) {
                _xml.setValidate(true);
            } else {
                _xml.setValidate(false);
            }
            if (this.result == null) return;
            destination.save(_xml);
            return;
        }
        catch (UniFormTransformationException e) {
            throw new InvalidDestinationException("Can not save the query result Reason: " + (Object)((Object)e));
        }
        catch (IOException e) {
            throw new IOException("Query Serialization I/O error: " + e);
        }
        catch (Exception e) {
            throw new IOException("Query Serialization error: " + e);
        }
        finally {
            destination.close();
        }
    }

    public void prepare(Statement statement) throws InvalidSourceException {
        this.prepare(statement, null);
    }

    public void prepare(Statement statement, Object resourceContext) throws InvalidSourceException {
        String srcId = statement.getSourceId();
        _log.debug((Object)("Prepare query: " + statement.toString() + " Context: " + resourceContext));
        Resource source = null;
        try {
            if (srcId != null) {
                source = ResourceResolver.getInstance().getResource(srcId);
                source.setContext(resourceContext);
                this.loadSource(source);
            }
        }
        catch (Exception e) {
            throw new InvalidSourceException("Can not prepare query's source. Source: " + srcId + " Reason: " + e);
        }
        finally {
            if (source != null) {
                source.close();
            }
        }
        this.statement = (BaseStatement)statement;
        this.resourceContext = resourceContext;
    }

    public void prepareNext(Statement statement) throws InvalidSourceException {
        if (this.result == null) {
            throw new InvalidSourceException("Query.prepareNext(" + statement + ") Query's result is NULL!");
        }
        this.input = this.result;
        this.statement = (BaseStatement)statement;
    }

    public void setInputStream(InputStream inputStream) throws InvalidSourceException {
        if (inputStream == null) {
            throw new InvalidSourceException("Can not init query inputStream with NULL value!");
        }
        try {
            this.input = new UniFormTreeFragment();
            ((UniFormTreeFragment)this.input).init(inputStream);
        }
        catch (UniFormTransformationException e) {
            throw new InvalidSourceException("Can not init query's inputStream. Reason: " + (Object)((Object)e));
        }
    }

    public void loadSource(Resource source) throws InvalidSourceException {
        try {
            this.input = (UniFormTree)source.load();
        }
        catch (UniFormTransformationException e) {
            throw new InvalidSourceException("Can not Load the source for the Query. Reason: " + (Object)((Object)e));
        }
        catch (IOException e) {
            throw new InvalidSourceException("Query Source I/O error: " + e);
        }
    }

    public XMLData getInput() {
        return this.input;
    }

    public void setInput(XMLData input) {
        this.input = (UniFormTree)input;
    }

    public XMLData getResult() {
        return this.result;
    }

    public void setResult(XMLData result) {
        this.result = (UniFormTree)result;
    }

    public Instruction getExecutedInstruction() throws ForbiddenOperationException {
        if (this.executedInstruction != null) {
            return this.executedInstruction;
        }
        return null;
    }

    public void setDestination(String destinationId) {
        this.statement.setDestinationId(destinationId);
    }

    public Query createNext(Statement statement) {
        Query q = null;
        try {
            q = new Query(statement);
            q.setInput(UniFormConverter.toFragment(this.result));
        }
        catch (Exception e) {
            _log.fatal((Object)"Query.createNext STRANGE Exception!", (Throwable)e);
        }
        return q;
    }
}

