/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.xml.querying.impl.xtas;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.exoplatform.services.xml.querying.InvalidStatementException;
import org.exoplatform.services.xml.querying.QueryRunTimeException;
import org.exoplatform.services.xml.querying.impl.xtas.Command;
import org.exoplatform.services.xml.querying.impl.xtas.UniFormTree;
import org.exoplatform.services.xml.querying.impl.xtas.UniFormTreeFragment;

public class QueryProcessor {
    private static TransformerFactory tFactory = TransformerFactory.newInstance();
    private Transformer transformer;

    protected UniFormTree process(Command command, UniFormTree input) throws QueryRunTimeException {
        if (this.transformer == null) {
            throw new QueryRunTimeException("QueryProcessor.process(): Query Run Time Exception. Transformer can not be NULL. Set init first! ");
        }
        try {
            UniFormTreeFragment fragment = new UniFormTreeFragment();
            if (!input.isEmpty()) {
                ByteArrayOutputStream os = new ByteArrayOutputStream();
                this.transformer.transform(new StreamSource(input.getAsInputStream()), new StreamResult(os));
                fragment.init(new ByteArrayInputStream(os.toByteArray()));
            }
            return fragment;
        }
        catch (Exception e) {
            throw new QueryRunTimeException("QueryProcessor.process(): Query Run Time Exception: " + e);
        }
    }

    public void init(Command command) throws InvalidStatementException {
        try {
            this.transformer = tFactory.newTransformer(new StreamSource(command.getAsInputStream()));
        }
        catch (Exception e) {
            throw new InvalidStatementException("QueryProcessor.init(): failed Reason: " + e);
        }
    }

    public void setParameter(String name, String value) throws InvalidStatementException {
        try {
            this.transformer.setParameter(name, value);
        }
        catch (Exception e) {
            throw new InvalidStatementException("QueryProcessor.init(): failed Reason: " + e);
        }
    }
}

