/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.xml.querying.impl.xtas;

import org.exoplatform.services.xml.querying.InvalidSourceException;
import org.exoplatform.services.xml.querying.InvalidStatementException;
import org.exoplatform.services.xml.querying.QueryRunTimeException;
import org.exoplatform.services.xml.querying.UniFormTransformationException;
import org.exoplatform.services.xml.querying.impl.xtas.Instruction;
import org.exoplatform.services.xml.querying.impl.xtas.UniFormConverter;
import org.exoplatform.services.xml.querying.impl.xtas.UniFormTree;
import org.exoplatform.services.xml.querying.impl.xtas.WellFormedUniFormTree;
import org.exoplatform.services.xml.querying.impl.xtas.resource.Resource;
import org.exoplatform.services.xml.querying.impl.xtas.resource.ResourceResolver;

public class ResourceInstruction
extends Instruction {
    private Object context;

    public ResourceInstruction(Instruction instr) {
        super(instr);
    }

    public ResourceInstruction(String type, String match, UniFormTree newValue) throws InvalidStatementException {
        super(type, match, newValue);
    }

    public String getAsString() {
        String matchStr = "";
        if (this.match != null) {
            matchStr = " resource=\"" + this.match + "\"";
        }
        return "<" + this.type + matchStr + ">" + this.newValue.getAsString() + "</" + this.type + ">";
    }

    public void compile() throws InvalidStatementException {
    }

    public UniFormTree execute(UniFormTree input) throws InvalidSourceException, QueryRunTimeException {
        try {
            Resource res = ResourceResolver.getInstance().getResource(this.match);
            res.setContext(this.context);
            if (this.type == "create") {
                WellFormedUniFormTree initTree = UniFormConverter.toWellForm(this.newValue);
                res.create(initTree);
                return this.newValue;
            }
            if (this.type == "drop") {
                res.drop();
                return null;
            }
        }
        catch (UniFormTransformationException e) {
            throw new InvalidSourceException("Bad Resource Instruction (possible newValue is not well-formed) : " + (Object)((Object)e));
        }
        catch (Exception e) {
            throw new QueryRunTimeException("Query Run Time Exception: " + e);
        }
        return null;
    }

    public void setContext(Object resourceContext) {
        this.context = resourceContext;
    }
}

