/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.xml.querying.impl.xtas;

import java.io.ByteArrayInputStream;
import java.io.SequenceInputStream;
import java.util.Enumeration;
import java.util.Properties;
import org.exoplatform.services.xml.querying.UniFormTransformationException;
import org.exoplatform.services.xml.querying.impl.xtas.UniFormTree;
import org.exoplatform.services.xml.querying.impl.xtas.UniFormTreeFragment;
import org.exoplatform.services.xml.querying.impl.xtas.WellFormedUniFormTree;
import org.xml.sax.InputSource;

public class UniFormConverter {
    public static WellFormedUniFormTree toWellForm(UniFormTree tree) throws UniFormTransformationException {
        if (tree instanceof WellFormedUniFormTree) {
            return (WellFormedUniFormTree)tree;
        }
        if (tree instanceof UniFormTreeFragment) {
            WellFormedUniFormTree wfTree = new WellFormedUniFormTree();
            wfTree.init(new InputSource(tree.getAsInputStream()));
            return wfTree;
        }
        throw new UniFormTransformationException("The type " + tree.getClass().getName() + " is not transformable to WellFormedUniFormTree! ");
    }

    public static WellFormedUniFormTree toWellForm(UniFormTree tree, String rootName) throws UniFormTransformationException {
        if (tree instanceof WellFormedUniFormTree || tree instanceof UniFormTreeFragment) {
            WellFormedUniFormTree wfTree = new WellFormedUniFormTree();
            SequenceInputStream s = new SequenceInputStream(new ByteArrayInputStream(("<" + rootName + ">").getBytes()), tree.getAsInputStream());
            s = new SequenceInputStream(s, new ByteArrayInputStream(("</" + rootName + ">").getBytes()));
            wfTree.init(new InputSource(s));
            return wfTree;
        }
        throw new UniFormTransformationException("The type " + tree.getClass().getName() + " is not transformable to WellFormedUniFormTree! ");
    }

    public static WellFormedUniFormTree toWellForm(UniFormTree tree, String rootName, String namespaceURI, Properties attrs) throws UniFormTransformationException {
        if (tree instanceof WellFormedUniFormTree || tree instanceof UniFormTreeFragment) {
            WellFormedUniFormTree wfTree = new WellFormedUniFormTree();
            String attributes = "";
            Enumeration<?> e = attrs.propertyNames();
            while (e.hasMoreElements()) {
                String name = (String)e.nextElement();
                attributes = attributes + name + "=\"" + attrs.getProperty(name) + "\" ";
            }
            String str = "<" + rootName + " " + namespaceURI + " " + attributes + ">";
            SequenceInputStream s = new SequenceInputStream(new ByteArrayInputStream(str.getBytes()), tree.getAsInputStream());
            s = new SequenceInputStream(s, new ByteArrayInputStream(("</" + rootName + ">").getBytes()));
            wfTree.init(new InputSource(s));
            return wfTree;
        }
        throw new UniFormTransformationException("The type " + tree.getClass().getName() + " is not transformable to WellFormedUniFormTree! ");
    }

    public static UniFormTreeFragment toFragment(UniFormTree tree) throws UniFormTransformationException {
        if (tree instanceof UniFormTreeFragment) {
            return (UniFormTreeFragment)tree;
        }
        if (tree instanceof WellFormedUniFormTree) {
            UniFormTreeFragment fragment = new UniFormTreeFragment();
            fragment.init(tree.getAsInputStream());
            return fragment;
        }
        throw new UniFormTransformationException("The type " + tree.getClass().getName() + " is not transformable to UniFormTreeFragment! ");
    }
}

