/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.xml.querying.impl.xtas;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import javax.xml.transform.Result;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.stream.StreamSource;
import org.exoplatform.services.xml.querying.XMLData;

public abstract class UniFormTree
implements XMLData {
    protected ByteArrayOutputStream thisStream = new ByteArrayOutputStream();
    protected Transformer transformer;
    protected static TransformerFactory tFactory;

    public UniFormTree() {
        try {
            this.transformer = tFactory.newTransformer();
            this.transformer.setOutputProperty("omit-xml-declaration", "yes");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public abstract byte[] getAsByteArray();

    public InputStream getAsInputStream() {
        return new ByteArrayInputStream(this.getAsByteArray());
    }

    public String getAsString() {
        return new String(this.getAsByteArray());
    }

    public boolean isEmpty() {
        return this.thisStream.size() == 0;
    }

    public void close() {
        this.thisStream = new ByteArrayOutputStream();
    }

    public String toString() {
        if (this.isEmpty()) {
            return "";
        }
        return this.getAsString().trim();
    }

    protected void convert(Result result) {
        try {
            this.convert(result, false);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    protected void convert(Result result, boolean withException) throws Exception {
        try {
            this.transformer.transform(new StreamSource(new ByteArrayInputStream(this.thisStream.toByteArray())), result);
        }
        catch (Exception e) {
            if (withException) {
                throw e;
            }
            e.printStackTrace();
        }
    }

    static {
        try {
            tFactory = TransformerFactory.newInstance();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

