/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.xml.querying.impl.xtas;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParserFactory;
import javax.xml.transform.Result;
import javax.xml.transform.Source;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.dom.DOMResult;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.sax.SAXResult;
import javax.xml.transform.sax.SAXTransformerFactory;
import javax.xml.transform.sax.TransformerHandler;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.exoplatform.services.xml.querying.UniFormTransformationException;
import org.exoplatform.services.xml.querying.XMLWellFormedData;
import org.exoplatform.services.xml.querying.impl.xtas.UniFormTree;
import org.exoplatform.services.xml.querying.impl.xtas.object.ObjectMarshaller;
import org.exoplatform.services.xml.querying.impl.xtas.object.ObjectMarshallerFactory;
import org.exoplatform.services.xml.querying.impl.xtas.xml.DtdTracer;
import org.exoplatform.services.xml.querying.impl.xtas.xml.Utils;
import org.exoplatform.services.xml.querying.object.MarshallerCreateException;
import org.exoplatform.services.xml.querying.object.ObjectMappingException;
import org.exoplatform.services.xml.querying.object.ObjectMarshalException;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.ContentHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;

public class WellFormedUniFormTree
extends UniFormTree
implements XMLWellFormedData {
    private DtdTracer validationHandler = new DtdTracer();
    protected XMLReader reader = null;
    protected TransformerHandler handler;
    protected static SAXTransformerFactory sFactory;
    protected static SAXParserFactory parserFactory;

    public WellFormedUniFormTree() throws UniFormTransformationException {
        try {
            this.handler = sFactory.newTransformerHandler();
            this.handler.setResult(new StreamResult(this.thisStream));
            this.handler.getTransformer().setOutputProperty("omit-xml-declaration", "yes");
            this.reader = parserFactory.newSAXParser().getXMLReader();
            this.reader.setContentHandler(this.handler);
            this.setValidate(false);
            this.reader.setProperty("http://xml.org/sax/properties/lexical-handler", this.validationHandler);
            this.reader.setProperty("http://xml.org/sax/properties/declaration-handler", this.validationHandler);
        }
        catch (Exception e) {
            throw new UniFormTransformationException(" WellFormedUniFormTree(InputStream stream) ERROR: Reason: " + e);
        }
    }

    public void init(InputSource src) throws UniFormTransformationException {
        try {
            this.reader.parse(src);
        }
        catch (Exception e) {
            throw new UniFormTransformationException("UniformTree.Init(inputStream): Can not parse InputSource Reason: " + e);
        }
    }

    public void init(Node node) throws UniFormTransformationException {
        try {
            this.thisStream = new ByteArrayOutputStream();
            this.transformer.transform(new DOMSource(node), new StreamResult(this.thisStream));
        }
        catch (Exception e) {
            throw new UniFormTransformationException("UniformTree.Init(Node): Can not Transform Reason: " + e);
        }
    }

    public void init(Object obj) throws ObjectMarshalException, MarshallerCreateException, ObjectMappingException {
        if (obj instanceof InputStream || obj instanceof NodeList || obj instanceof Document || obj instanceof InputSource) {
            throw new ObjectMappingException("DEV-ERROR! init(Object) Parameter MUST NOT BE " + obj.getClass().getName() + " TYPE!");
        }
        this.init(obj.getClass(), obj);
    }

    public void init(Object mapping, Object obj) throws ObjectMarshalException, MarshallerCreateException, ObjectMappingException {
        this.thisStream = new ByteArrayOutputStream();
        int mappingType = 0;
        if (!(mapping instanceof Class)) {
            mappingType = 1;
        }
        ObjectMarshaller marshaller = ObjectMarshallerFactory.getInstance().getMarshaller(mappingType);
        marshaller.loadMapping(mapping);
        try {
            Document doc = Utils.createDocument();
            doc = marshaller.marshal(obj);
            this.transformer.transform(new DOMSource(doc), new StreamResult(this.thisStream));
        }
        catch (Exception e) {
            throw new ObjectMarshalException("UniFormTree.init(Object mapping, Object obj) Exception: " + e);
        }
    }

    public void initRoot(String nodeName) throws UniFormTransformationException {
        try {
            this.init(new InputSource(new ByteArrayInputStream(("<" + nodeName + "> </" + nodeName + ">").getBytes())));
        }
        catch (Exception e) {
            throw new UniFormTransformationException("UniformTree.Init(inputStream): Can not parse InputSource Reason: " + e);
        }
    }

    public byte[] getAsByteArray() {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        StreamResult sr = new StreamResult(bos);
        this.convert(sr);
        return bos.toByteArray();
    }

    public Node getAsDOM() {
        Document tmpDoc = null;
        try {
            tmpDoc = Utils.createDocument();
        }
        catch (ParserConfigurationException parserConfigurationException) {
            // empty catch block
        }
        this.convert(new DOMResult(tmpDoc));
        return tmpDoc;
    }

    public void processAsSAX(ContentHandler handler) throws SAXException {
        try {
            this.convert(new SAXResult(handler), true);
        }
        catch (Exception e) {
            throw new SAXException("WellFormedUniFormTree.processAsSAX() failed. Reason: " + e);
        }
    }

    public void transformWithXSL(Result result, Source xslTemplate) throws TransformerException {
        try {
            if (xslTemplate == null) {
                this.convert(result, true);
            } else {
                Transformer trans = tFactory.newTransformer(xslTemplate);
                trans.transform(new StreamSource(new ByteArrayInputStream(this.thisStream.toByteArray())), result);
            }
        }
        catch (Exception e) {
            throw new TransformerException("WellFormedUniFormTree.transformWithXSL() failed. Reason: " + e);
        }
    }

    public void setOmitXmlDeclaration(boolean yesNo) {
        this.transformer.setOutputProperty("omit-xml-declaration", yesNo ? "yes" : "no");
    }

    public void setIndentOutput(boolean yesNo) {
        this.transformer.setOutputProperty("indent", yesNo ? "yes" : "no");
    }

    public void setDTDSystemId(String systemId) {
        this.transformer.setOutputProperty("doctype-system", systemId);
    }

    public void setDTDPublicId(String publicId) {
        this.transformer.setOutputProperty("doctype-public", publicId);
    }

    public DtdTracer getValidationHandler() {
        return this.validationHandler;
    }

    public void setValidate(boolean yesNo) {
        try {
            this.reader.setFeature("http://xml.org/sax/features/validation", yesNo);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    static {
        try {
            parserFactory = SAXParserFactory.newInstance();
            sFactory = (SAXTransformerFactory)tFactory;
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

