/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.xml.querying.impl.xtas;

import org.exoplatform.services.xml.querying.InvalidSourceException;
import org.exoplatform.services.xml.querying.InvalidStatementException;
import org.exoplatform.services.xml.querying.QueryRunTimeException;
import org.exoplatform.services.xml.querying.impl.xtas.Command;
import org.exoplatform.services.xml.querying.impl.xtas.Instruction;
import org.exoplatform.services.xml.querying.impl.xtas.QueryProcessor;
import org.exoplatform.services.xml.querying.impl.xtas.QueryProcessorFactory;
import org.exoplatform.services.xml.querying.impl.xtas.UniFormTree;

public class XMLInstruction
extends Instruction {
    private static QueryProcessor processor = QueryProcessorFactory.getInstance().getProcessor();
    Command command;

    public XMLInstruction(Instruction instr) {
        super(instr);
    }

    public XMLInstruction(String type, String match, UniFormTree newValue) throws InvalidStatementException {
        super(type, match, newValue);
    }

    public String getAsString() {
        String matchStr = "";
        if (this.match != null) {
            matchStr = " xpath=\"" + this.match + "\"";
        }
        return "<" + this.type + matchStr + ">" + this.newValue.getAsString() + "</" + this.type + ">";
    }

    public void compile() throws InvalidStatementException {
        this.command = compiler.compile(this.getAsString());
        processor.init(this.command);
    }

    public String getCommandAsString() {
        return this.command.toString();
    }

    public UniFormTree execute(UniFormTree input) throws InvalidSourceException, QueryRunTimeException {
        if (input == null) {
            throw new InvalidSourceException("Query execution Error: XTAS Source Can Not be NULL !");
        }
        if (this.command == null) {
            throw new QueryRunTimeException("Query execution Error: Command has not be created, call compile() first!");
        }
        return processor.process(this.command, input);
    }

    public void setContext(Object resourceContext) {
    }
}

