/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.xml.querying.impl.xtas;

import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;

public class XTASMLContentHandler
implements ContentHandler {
    private static final int ROOT = 0;
    private static final int QUERY = 1;
    private static final int INSTRUCTION = 2;
    private int state = 0;
    private boolean hasPrefixes = false;
    private String sourceId;
    private String destinationId;
    private String match;
    private String type;
    private String newValue = "";

    public void setDocumentLocator(Locator locator) {
    }

    public void startDocument() throws SAXException {
    }

    public void endDocument() throws SAXException {
    }

    public void startPrefixMapping(String prefix, String uri) throws SAXException {
        this.hasPrefixes = true;
    }

    public void endPrefixMapping(String prefix) throws SAXException {
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void startElement(String namespaceURI, String localName, String qName, Attributes atts) throws SAXException {
        if (this.state == 0) {
            if (!localName.equals("query")) throw new SAXException("The XTASML's root element must be 'query'!");
            int n = atts.getLength();
            for (int i = 0; i < n; ++i) {
                if (atts.getLocalName(i).equals("source")) {
                    this.sourceId = atts.getValue(i);
                    continue;
                }
                if (atts.getLocalName(i).equals("destination")) {
                    this.destinationId = atts.getValue(i);
                    continue;
                }
                if (this.hasPrefixes) continue;
                throw new SAXException("Unknown query attribute '" + atts.getQName(i) + "'!");
            }
            this.state = 1;
            return;
        } else if (this.state == 1) {
            this.type = localName;
            int n = atts.getLength();
            for (int i = 0; i < n; ++i) {
                if (!(atts.getLocalName(i).equals("match") || atts.getLocalName(i).equals("xpath") || atts.getLocalName(i).equals("resource"))) {
                    throw new SAXException("Unknown query attribute '" + atts.getQName(i) + "'!");
                }
                this.match = atts.getValue(i);
            }
            this.state = 2;
            return;
        } else {
            if (this.state != 2) return;
            this.newValue = this.newValue + "<" + localName;
            int n = atts.getLength();
            for (int i = 0; i < n; ++i) {
                this.newValue = this.newValue + " " + atts.getLocalName(i) + "=\"" + atts.getValue(i) + "\"";
            }
            this.newValue = this.newValue + ">";
        }
    }

    public void endElement(String namespaceURI, String localName, String qName) throws SAXException {
        if (localName == this.type) {
            this.state = 1;
        }
        if (this.state == 2) {
            this.newValue = this.newValue + "</" + localName + ">";
        }
    }

    public void characters(char[] ch, int start, int length) throws SAXException {
        String s = new String(ch, start, length);
        this.newValue = this.newValue + s.trim();
    }

    public void ignorableWhitespace(char[] ch, int start, int length) throws SAXException {
        String s = new String(ch, start, length);
        this.newValue = this.newValue + s;
    }

    public void processingInstruction(String target, String data) throws SAXException {
    }

    public void skippedEntity(String name) throws SAXException {
    }

    public String getSourceId() {
        return this.sourceId;
    }

    public String getDestinationId() {
        return this.destinationId;
    }

    public String getType() {
        return this.type;
    }

    public String getMatch() {
        return this.match;
    }

    public String getNewValue() {
        return this.newValue;
    }
}

