/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.xml.querying.impl.xtas;

import java.io.ByteArrayInputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import javax.xml.parsers.FactoryConfigurationError;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.exoplatform.services.xml.querying.InvalidStatementException;
import org.exoplatform.services.xml.querying.impl.xtas.BaseStatement;
import org.exoplatform.services.xml.querying.impl.xtas.UniFormTreeFragment;
import org.exoplatform.services.xml.querying.impl.xtas.XTASMLContentHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;

public class XTASMLStatement
extends BaseStatement {
    public XTASMLStatement(String fileName) throws IOException, InvalidStatementException, SAXException {
        this(new FileInputStream(fileName));
    }

    public XTASMLStatement(URL url) throws IOException, InvalidStatementException, SAXException {
        this(url.openStream());
    }

    public XTASMLStatement(InputStream statStream) throws InvalidStatementException, SAXException {
        XMLReader reader = null;
        try {
            SAXParserFactory factory = SAXParserFactory.newInstance();
            factory.setNamespaceAware(true);
            SAXParser jaxpParser = factory.newSAXParser();
            reader = jaxpParser.getXMLReader();
        }
        catch (ParserConfigurationException ex) {
            throw new SAXException(ex);
        }
        catch (FactoryConfigurationError ex1) {
            throw new SAXException(ex1.toString());
        }
        catch (NoSuchMethodError ex2) {
            // empty catch block
        }
        XTASMLContentHandler handler = new XTASMLContentHandler();
        reader.setContentHandler(handler);
        try {
            reader.parse(new InputSource(statStream));
        }
        catch (IOException e) {
            throw new SAXException(e);
        }
        try {
            this.sourceId = handler.getSourceId();
            this.destinationId = handler.getDestinationId();
            UniFormTreeFragment nv = new UniFormTreeFragment();
            nv.init(new ByteArrayInputStream(handler.getNewValue().getBytes()));
            this.addInstruction(handler.getType(), handler.getMatch(), nv);
        }
        catch (Exception e) {
            throw new InvalidStatementException("XTASMLStatement Create ERROR:" + e);
        }
    }

    public XTASMLStatement(byte[] stat) throws InvalidStatementException, SAXException {
        this(new ByteArrayInputStream(stat));
    }
}

