/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.xml.querying.impl.xtas.object.plugins;

import java.util.ArrayList;
import java.util.Collection;
import org.exolab.castor.xml.MarshalException;
import org.exolab.castor.xml.Marshaller;
import org.exolab.castor.xml.Unmarshaller;
import org.exolab.castor.xml.ValidationException;
import org.exoplatform.services.xml.querying.impl.xtas.object.ObjectMarshaller;
import org.exoplatform.services.xml.querying.impl.xtas.xml.Utils;
import org.exoplatform.services.xml.querying.object.ObjectMappingException;
import org.exoplatform.services.xml.querying.object.ObjectMarshalException;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class CastorClassMarshaller
implements ObjectMarshaller {
    private Class mapping;

    public void loadMapping(Object source) throws ObjectMappingException {
        if (!(source instanceof Class)) {
            throw new ObjectMappingException("ObjectMappingException: Data Source (" + source.getClass().getName() + ") for mapping is invalid !");
        }
        this.mapping = (Class)source;
    }

    public Document marshal(Object obj) throws ObjectMarshalException, ObjectMappingException {
        if (this.mapping == null) {
            throw new ObjectMappingException("ObjectMarshaller's mapping can not be NULL. Call loadMapping() first ! ");
        }
        try {
            Document doc = Utils.createDocument();
            Marshaller.marshal((Object)obj, (Node)doc);
            return doc;
        }
        catch (Exception e) {
            throw new ObjectMarshalException("ObjectMarshalException occured! Reason: " + e.getMessage());
        }
    }

    public Collection unmarshal(Document source) throws ObjectMarshalException, ObjectMappingException {
        if (this.mapping == null) {
            throw new ObjectMappingException("ObjectMarshaller's mapping can not be NULL. Call loadMapping() first ! ");
        }
        try {
            ArrayList<Object> list = new ArrayList<Object>();
            NodeList nl = source.getDocumentElement().getChildNodes();
            for (int i = 0; i < nl.getLength(); ++i) {
                Node child = nl.item(i);
                if (child.getNodeType() != 1) continue;
                list.add(Unmarshaller.unmarshal((Class)this.mapping, (Node)child));
            }
            return list;
        }
        catch (MarshalException e) {
            throw new ObjectMarshalException(e.getMessage());
        }
        catch (ValidationException e) {
            throw new ObjectMarshalException(e.getMessage());
        }
    }
}

