/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.xml.querying.impl.xtas.object.plugins;

import java.io.IOException;
import java.net.URL;
import java.util.Collection;
import java.util.Iterator;
import org.exolab.castor.mapping.Mapping;
import org.exolab.castor.mapping.MappingException;
import org.exolab.castor.xml.MarshalException;
import org.exolab.castor.xml.Marshaller;
import org.exolab.castor.xml.Unmarshaller;
import org.exolab.castor.xml.ValidationException;
import org.exoplatform.services.xml.querying.impl.xtas.Query;
import org.exoplatform.services.xml.querying.impl.xtas.SimpleStatement;
import org.exoplatform.services.xml.querying.impl.xtas.UniFormConverter;
import org.exoplatform.services.xml.querying.impl.xtas.UniFormTree;
import org.exoplatform.services.xml.querying.impl.xtas.UniFormTreeFragment;
import org.exoplatform.services.xml.querying.impl.xtas.WellFormedUniFormTree;
import org.exoplatform.services.xml.querying.impl.xtas.object.ObjectMarshaller;
import org.exoplatform.services.xml.querying.impl.xtas.object.plugins.CastorMapToElement;
import org.exoplatform.services.xml.querying.impl.xtas.object.plugins.SyntheticalRoot;
import org.exoplatform.services.xml.querying.impl.xtas.xml.Utils;
import org.exoplatform.services.xml.querying.object.ObjectMappingException;
import org.exoplatform.services.xml.querying.object.ObjectMarshalException;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.xml.sax.InputSource;

public class CastorMappedMarshaller
implements ObjectMarshaller {
    private Mapping mapping;

    public void loadMapping(Object source) throws ObjectMappingException {
        this.mapping = new Mapping(this.getClass().getClassLoader());
        try {
            InputSource src;
            if (source instanceof InputSource) {
                src = (InputSource)source;
            } else if (source instanceof String) {
                src = new InputSource((String)source);
            } else if (source instanceof URL) {
                src = new InputSource(((URL)source).toString());
            } else {
                throw new ObjectMappingException("ObjectMappingException: Data Source (" + source.getClass().getName() + ") for mapping is invalid !");
            }
            this.mapping.loadMapping(this.createMapping(src));
        }
        catch (IOException e) {
            throw new ObjectMappingException("ObjectMappingException (I/O) thrown! Reason: " + e.getMessage());
        }
        catch (MappingException e) {
            throw new ObjectMappingException("ObjectMappingException thrown! Reason: " + e.getMessage());
        }
    }

    public Document marshal(Object obj) throws ObjectMarshalException, ObjectMappingException {
        if (this.mapping == null) {
            throw new ObjectMappingException("ObjectMarshaller's mapping can not be NULL. Call loadMapping() first ! ");
        }
        try {
            Document doc = Utils.createDocument();
            Marshaller marshaller = new Marshaller((Node)doc);
            marshaller.setMapping(this.mapping);
            marshaller.marshal(obj);
            return doc;
        }
        catch (Exception e) {
            throw new ObjectMarshalException("ObjectMarshalException occured! Reason: " + e.getMessage());
        }
    }

    public Collection unmarshal(Document source) throws ObjectMarshalException, ObjectMappingException {
        if (this.mapping == null) {
            throw new ObjectMappingException("ObjectMarshaller's mapping can not be NULL. Call loadMapping() first ! ");
        }
        try {
            Unmarshaller unmar = new Unmarshaller(this.mapping);
            SyntheticalRoot oo = (SyntheticalRoot)unmar.unmarshal((Node)source);
            return oo.getObjects();
        }
        catch (MappingException e) {
            throw new ObjectMappingException(e.getMessage());
        }
        catch (MarshalException e) {
            throw new ObjectMarshalException(e.getMessage());
        }
        catch (ValidationException e) {
            throw new ObjectMarshalException(e.getMessage());
        }
    }

    private InputSource createMapping(InputSource source) throws ObjectMappingException {
        try {
            WellFormedUniFormTree mapTree = new WellFormedUniFormTree();
            mapTree.init(source);
            Query q1 = new Query(SimpleStatement.select("/mapping/class/map-to", source.getSystemId()));
            q1.execute();
            UniFormTreeFragment f = UniFormConverter.toFragment((UniFormTree)q1.getResult());
            Iterator elements = f.getAsCollection(CastorMapToElement.class).iterator();
            String str = "<class name=\"org.exoplatform.services.xml.querying.impl.xtas.object.plugins.SyntheticalRoot\"><map-to xml=\"synthetical-root\"/><field name=\"objects\" collection=\"collection\">";
            String name = ((CastorMapToElement)elements.next()).getXml();
            str = str + "<bind-xml name=\"" + name + "\"/>";
            str = str + "</field></class>";
            SimpleStatement add = new SimpleStatement("append", "mapping/class[last()]", str);
            Query q = new Query(add);
            q.setInputStream(mapTree.getAsInputStream());
            q.execute();
            return new InputSource(q.getResult().getAsInputStream());
        }
        catch (Exception e) {
            throw new ObjectMappingException("Exception while create mapping thrown! Reason: " + e.getMessage());
        }
    }
}

