/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.xml.querying.impl.xtas.resource;

import java.net.MalformedURLException;
import java.util.Collection;
import java.util.Iterator;
import org.exoplatform.services.xml.querying.ConfigException;
import org.exoplatform.services.xml.querying.impl.xtas.XMLConfig;
import org.exoplatform.services.xml.querying.impl.xtas.resource.Resource;
import org.exoplatform.services.xml.querying.impl.xtas.resource.ResourceDescriptor;
import org.exoplatform.services.xml.querying.impl.xtas.resource.plugins.LocalFile;

public class ResourceResolver {
    private static ResourceResolver resolver = null;
    private Collection descriptors = XMLConfig.getInstance().getResources();

    protected ResourceResolver() throws ConfigException {
    }

    public static ResourceResolver getInstance() throws ConfigException {
        if (resolver == null) {
            resolver = new ResourceResolver();
        }
        return resolver;
    }

    public Resource getResource(String resourceId) throws MalformedURLException, ConfigException {
        Iterator iter = this.descriptors.iterator();
        Resource res = null;
        while (iter.hasNext()) {
            ResourceDescriptor descr = (ResourceDescriptor)iter.next();
            String prefix = descr.getPrefix();
            if (prefix == null || prefix.length() > resourceId.length() || !prefix.equals(resourceId.substring(0, prefix.length()))) continue;
            try {
                res = (Resource)Class.forName(descr.getClassname()).newInstance();
            }
            catch (Exception e) {
                throw new ConfigException("XTAS Resource Config Exception - can not instantiate: " + e.getMessage());
            }
            res.init(resourceId);
            return res;
        }
        return new LocalFile(resourceId);
    }
}

