/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.xml.querying.impl.xtas.resource.plugins;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import org.exoplatform.services.xml.querying.UniFormTransformationException;
import org.exoplatform.services.xml.querying.XMLWellFormedData;
import org.exoplatform.services.xml.querying.impl.xtas.WellFormedUniFormTree;
import org.exoplatform.services.xml.querying.impl.xtas.resource.Resource;
import org.xml.sax.InputSource;

public class LocalFile
extends Resource {
    public LocalFile(String resourceId) {
        this.resourceId = resourceId;
    }

    public LocalFile() {
    }

    public void setContext(Object context) {
    }

    public XMLWellFormedData load() throws UniFormTransformationException, IOException {
        File file = new File(this.resourceId);
        try {
            WellFormedUniFormTree tree = new WellFormedUniFormTree();
            tree.init(new InputSource(file.getCanonicalPath()));
            return tree;
        }
        catch (Exception e) {
            throw new UniFormTransformationException("Can not create WellFormedUniFormTree (XML) Reason: " + e);
        }
    }

    public void save(XMLWellFormedData tree) throws IOException {
        FileOutputStream fos = new FileOutputStream(this.resourceId);
        byte[] b = tree.getAsByteArray();
        fos.write(b, 0, b.length);
        fos.flush();
        fos.close();
    }

    public void create(XMLWellFormedData initTree) throws IOException {
        File res = new File(this.resourceId);
        if (!res.createNewFile()) {
            throw new IOException(" File '" + res.getAbsolutePath() + "' already exists.");
        }
    }

    public void drop() throws IOException {
        File res = new File(this.resourceId);
        if (!res.delete()) {
            throw new IOException(" File '" + res.getAbsolutePath() + "' can not be deleted.");
        }
    }
}

